/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.SfcMitem;
import com.mushiny.wms.application.repository.SfcMitemRepository;
import com.mushiny.wms.common.Constant;
import com.mushiny.wms.common.utils.CommonUtil;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@Transactional
public class SfcMitemBusiness {
    private Logger LOG = LoggerFactory.getLogger((String)SfcMitemBusiness.class.getName());
    private RestTemplate restTemplate = new RestTemplate();
    @Autowired
    private RestTempConfig restTempConfig;
    private final SfcMitemRepository sfcMitemRepository;
    @Value(value="${midea.webApi.INV_ORG_ID}")
    private String INV_ORG_ID;

    @Autowired
    public SfcMitemBusiness(SfcMitemRepository sfcMitemRepository) {
        this.sfcMitemRepository = sfcMitemRepository;
    }

    public List<SfcMitem> receive(String param) {
        Map tt = JSONUtil.jsonToMap((String)param);
        HashMap paramMap = new HashMap();
        paramMap.put("LAST_UPDATE_DATE", tt.get("LAST_UPDATE_DATE"));
        paramMap.put("INV_ORG_ID", this.INV_ORG_ID);
        String result = this.restTempConfig.sfcMitemSyn(paramMap);
        Map resultMap1 = JSONUtil.jsonToMap((String)result);
        List resultMap = (List)resultMap1.get("ListData");
        ArrayList<SfcMitem> sfcMitems = new ArrayList<SfcMitem>();
        for (Map t : resultMap) {
            SfcMitem t2 = (SfcMitem)JSONUtil.mapToBean((Map)t, (Object)new SfcMitem());
            sfcMitems.add(t2);
        }
        return this.saveSfcMitem(sfcMitems);
    }

    @Scheduled(fixedDelay=3600000L, initialDelay=2000L)
    @Async
    public void execute() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("INV_ORG_ID", this.INV_ORG_ID);
        Date date = this.sfcMitemRepository.getLastUpdateDate();
        String ss = "2018-06-01";
        if (!ObjectUtils.isEmpty((Object)date)) {
            ss = DateTimeUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        paramMap.put("LAST_UPDATE_DATE", ss);
        String result = this.restTempConfig.sfcMitemSyn(paramMap);
        Map resultMap1 = JSONUtil.jsonToMap((String)result);
        List resultMap = (List)resultMap1.get("ListData");
        ArrayList<SfcMitem> sfcMitems = new ArrayList<SfcMitem>();
        for (Map t : resultMap) {
            SfcMitem t2 = (SfcMitem)JSONUtil.mapToBean((Map)t, (Object)new SfcMitem());
            sfcMitems.add(t2);
        }
        List resultSfcMitem = this.saveSfcMitem(sfcMitems);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("\u7269\u6599\u4fe1\u606f\u540c\u6b65\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)resultSfcMitem));
        }
    }

    public void mItems() {
        try {
            HashMap<String, Number> paramMap = new HashMap<String, Number>();
            paramMap.put("LAST_UPDATE_DATE", Constant.LAST_UPDATE_DATE);
            paramMap.put("INV_ORG_ID", Constant.INV_ORG_ID);
            ResponseEntity responseEntity = this.restTemplate.getForEntity("http://localhost:12004/mItems?LAST_UPDATE_DATE=" + Constant.LAST_UPDATE_DATE + "&INV_ORG_ID=" + Constant.INV_ORG_ID, String.class, new Object[]{""});
            String jsonString = (String)responseEntity.getBody();
            this.LOG.info(" < < < - - - \u7269\u6599\u4fe1\u606f\u540c\u6b65\u8bf7\u6c42\u53cd\u9988\u7ed3\u679c(\u8bf7\u6c42\u6700\u540e\u66f4\u65b0\u65f6\u95f4\uff1a" + CommonUtil.dateFormat((Date)new Date(Constant.LAST_UPDATE_DATE)) + ")\u3002\u3002\u3002\n " + jsonString);
            Class<SfcMitem> sfcMitemClass = SfcMitem.class;
            List sfcMitems = CommonUtil.mideaListParamJsonModify((String)jsonString, SfcMitem.class);
            this.saveSfcMitem(sfcMitems);
            this.LOG.info(" \u7269\u6599\u4fe1\u606f\u540c\u6b65\u6210\u529f(\u8bf7\u6c42\u6700\u540e\u66f4\u65b0\u65f6\u95f4\uff1a" + CommonUtil.dateFormat((Date)new Date(Constant.LAST_UPDATE_DATE)) + ")\u3002\u3002\u3002 ");
        }
        catch (RestClientException e) {
            e.printStackTrace();
            this.LOG.info(" \u7269\u6599\u4fe1\u606f\u540c\u6b65\u5931\u8d25\u3002\u3002\u3002 ", (Throwable)e);
        }
    }

    public List<SfcMitem> saveSfcMitem(List<SfcMitem> sfcMitems) {
        sfcMitems = CommonUtil.removeSameItem(sfcMitems, (List)this.sfcMitemRepository.findAll());
        List result = this.sfcMitemRepository.save((Iterable)sfcMitems);
        return result;
    }

    public Integer saveSfcMitem(SfcMitem sfcMitem) {
        this.sfcMitemRepository.save((Object)sfcMitem);
        return 1;
    }
}

