/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.business.common.BuildEntityBusiness;
import com.mushiny.wms.application.business.common.PodReserveUtil;
import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.Constance;
import com.mushiny.wms.application.domain.Map;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.WmsInstructOutPosition;
import com.mushiny.wms.application.domain.WmsInvStockunit;
import com.mushiny.wms.application.domain.WmsInvUnitload;
import com.mushiny.wms.application.domain.enums.InstructStatus;
import com.mushiny.wms.application.domain.enums.PodStateEnum;
import com.mushiny.wms.application.domain.enums.StationType;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.rabbitMq.RabbitMessageSender;
import com.mushiny.wms.application.repository.MapRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.StationnodeRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WmsInstructOutPositionRepository;
import com.mushiny.wms.application.repository.WmsInvStockunitRepository;
import com.mushiny.wms.application.repository.WmsInvUnitLoadRepository;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@Transactional
public class RfidBusiness {
    private static final Logger LOGGER = LoggerFactory.getLogger(RfidBusiness.class);
    private final PodRepository podRepository;
    private final StationnodeRepository stationnodeRepository;
    private final BuildEntityBusiness buildEntityBusiness;
    private final TripRepository tripRepository;
    private final SectionRepository sectionRepository;
    @Autowired
    private RabbitMessageSender rabbitMessageSender;
    private PodReserveUtil podReserveUtil;
    @Autowired
    private RestTempConfig restTempConfig;
    @Autowired
    private WmsInstructOutPositionRepository wminstructOutPositionRepository;
    @Autowired
    private WmsInvUnitLoadRepository wmsInvUnitLoadRepository;
    @Autowired
    private WmsInvStockunitRepository wmsInvStockunitRepository;
    @Autowired
    private MapRepository mapRepository;
    private String sectionId = "ec229eb7-7e2b-43a8-b1c7-91bd807e91cf";

    @Autowired
    public RfidBusiness(PodRepository podRepository, StationnodeRepository stationnodeRepository, PodReserveUtil podReserveUtil, BuildEntityBusiness buildEntityBusiness, TripRepository tripRepository, SectionRepository sectionRepository) {
        this.podReserveUtil = podReserveUtil;
        this.buildEntityBusiness = buildEntityBusiness;
        this.podRepository = podRepository;
        this.stationnodeRepository = stationnodeRepository;
        this.tripRepository = tripRepository;
        this.sectionRepository = sectionRepository;
    }

    public void autoRemove() {
        List maps = this.mapRepository.findAllMap();
        if (!CollectionUtils.isEmpty((Collection)maps) && maps.size() == 1) {
            List pods = this.podRepository.getStationPod(((Map)maps.get(0)).getSectionId(), Arrays.asList(StationType.OUTBOUNDAUTO, StationType.OUTBOUNDMANUL));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u67e5\u627e\u9700\u8981\u79fb\u9664\u8d27\u67b6 {}", (Object)JSONUtil.toJSon((Object)pods));
            }
            for (Pod pod : pods) {
                HashMap<String, Integer> temp = new HashMap<String, Integer>();
                temp.put("podIndex", pod.getPodIndex());
                temp.put("podAddress", 0);
                this.saveRfidInfo(temp);
            }
        } else {
            LOGGER.error("\u67e5\u627e\u5230\u591a\u4e2a\u5730\u56fe\uff0c\u505c\u6b62\u79fb\u9664\u8d27\u67b6 {}", (Object)JSONUtil.toJSon((Object)maps));
        }
    }

    public Integer saveRfidInfo(java.util.Map pods) {
        Integer result = 1;
        List maps = this.mapRepository.findAllMap();
        if (!CollectionUtils.isEmpty((Collection)maps) && maps.size() == 1) {
            Integer podAddress = (Integer)NumberUtils.parseNumber((String)("" + pods.get("podAddress")), Integer.class);
            Integer podIndex = (Integer)NumberUtils.parseNumber((String)("" + pods.get("podIndex")), Integer.class);
            LOGGER.debug("\u63a5\u6536\u5230RFIF\u4fe1\u606f\u4e3a{}", (Object)JSONUtil.toJSon((Object)pods));
            char[] podName = new char[]{'P', '0', '0', '0', '0', '0', '0', '0'};
            if (!StringUtils.isEmpty((Object)podIndex)) {
                char[] podtemp = (podIndex + "").toCharArray();
                int beagin = podName.length;
                int charLen = podtemp.length;
                char[] cArray = podtemp;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char t;
                    podName[beagin - charLen] = t = cArray[i];
                    ++beagin;
                }
                Pod ext = this.podRepository.getByPodIndex2(podIndex.intValue());
                if (!ObjectUtils.isEmpty((Object)ext)) {
                    ext.setPlaceMark(podAddress);
                } else {
                    ext = new Pod();
                    ext.setName(new String(podName));
                    ext.setPodIndex(podIndex);
                    ext.setPodTypeId("168e0596-ef79-4661-ae3e-7d7f760d95cd");
                    ext.setZoneId("0134c83e-5b55-4706-a51c-01b671b18a7d");
                    ext.setSectionId(((Map)maps.get(0)).getSectionId());
                    ext.setClientId("SYSTEM");
                    ext.setPlaceMark(podAddress);
                    ext.setxPos(Integer.valueOf(19));
                    ext.setyPos(Integer.valueOf(20));
                    ext.setState(PodStateEnum.RESERVED.getName());
                    ext.setToward(Integer.valueOf(0));
                    ext.setWarehouseId("DEFAULT");
                    ext = (Pod)this.podRepository.saveAndFlush((Object)ext);
                }
                this.inventoryReduction(ext);
            } else {
                result = 0;
            }
        } else {
            result = 0;
        }
        return result;
    }

    public Integer workStationCall(String stationName, Integer iscall) {
        return this.stationnodeRepository.workstationCall(stationName, iscall, this.sectionId);
    }

    public void OutBoundInstructCallBack(Integer podIndex) {
        if (!ObjectUtils.isEmpty((Object)podIndex)) {
            Pod ext = this.podRepository.getByPodIndex2(podIndex.intValue());
            if (!ObjectUtils.isEmpty((Object)ext)) {
                List otP = this.wminstructOutPositionRepository.getInstructOutPositionByRFIDPod(ext.getName());
                if (!CollectionUtils.isEmpty((Collection)otP) && otP.size() == 1) {
                    OutboundInstruct outboundInstruct = ((WmsInstructOutPosition)otP.get(0)).getOutboundInstruct();
                    if (outboundInstruct.getBILL_TYPE().equalsIgnoreCase(TripType.LMGETMATERIAL.getName())) {
                        String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("ID", outboundInstruct.getMES_ID());
                        param.put("INV_ORG_ID", outboundInstruct.getINV_ORG_ID());
                        param.put("BILL_TYPE", outboundInstruct.getBILL_TYPE());
                        param.put("BILL_NO", outboundInstruct.getBILL_NO());
                        param.put("LABEL_NO", outboundInstruct.getLABEL_NO());
                        param.put("INV_CODE", outboundInstruct.getINV_CODE());
                        param.put("STOCK_QTY", outboundInstruct.getQTY());
                        param.put("STORAGE_NO_L", ((WmsInstructOutPosition)otP.get(0)).getSTORAGE_NO_L());
                        param.put("CAR_NO", ((WmsInstructOutPosition)otP.get(0)).getCAR_NO());
                        param.put("LOC_CODE", ((WmsInstructOutPosition)otP.get(0)).getLOC_CODE());
                        param.put("DATETIME_STOCK", datetimeStock);
                        param.put("STATUS", InstructStatus.DISPATCH.getStatus());
                        this.restTempConfig.outBoundAck(param);
                        WmsInstructOutPosition iop = new WmsInstructOutPosition();
                        iop.setCAR_NO(((WmsInstructOutPosition)otP.get(0)).getCAR_NO());
                        iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                        iop.setOutboundInstruct(outboundInstruct);
                        iop.setSTATUS(InstructStatus.DISPATCH.getStatus());
                        iop.setSTOCK_QTY(outboundInstruct.getQTY().toString());
                        iop = (WmsInstructOutPosition)this.wminstructOutPositionRepository.saveAndFlush((Object)iop);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("\u4fdd\u5b58\u51fa\u5e93\u6307\u4ee4\u914d\u9001\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iop));
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("pod {} \u5bf9\u5e94\u7684\u6307\u4ee4\u4e0d\u662f\u9886\u6599\u51fa\u5e93\u7c7b\u578b\n{}", (Object)ext.getName(), (Object)JSONUtil.toJSon((Object)otP));
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("pod {} \u67e5\u8be2\u5230\u591a\u4e2a\u51fa\u5e93\u6307\u4ee4\n{}", (Object)ext.getName(), (Object)JSONUtil.toJSon((Object)otP));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u7cfb\u7edf\u4e0d\u5b58\u5728pod {}", (Object)podIndex);
            }
        }
    }

    public void inventoryReduction(Pod pod) {
        WmsInvUnitload wil = this.wmsInvUnitLoadRepository.getUnitLoadByPodIndex(pod.getPodIndex(), Constance.stockInUnit);
        if (!ObjectUtils.isEmpty((Object)wil)) {
            wil.setEntityLock(Constance.stockOutUnit);
            this.wmsInvUnitLoadRepository.saveAndFlush((Object)wil);
            WmsInvStockunit isku = this.wmsInvStockunitRepository.getStockUnitByUnitLoadId(wil.getId(), Constance.stockInUnit);
            if (!ObjectUtils.isEmpty((Object)isku)) {
                isku.setEntityLock(Constance.stockOutUnit);
                this.wmsInvStockunitRepository.saveAndFlush((Object)isku);
            }
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ID", pod.getId());
        param.put("NAME", pod.getName());
        param.put("TOWARD", "0");
        param.put("SECTION_ID", pod.getSectionId());
        param.put("PLACEMARK", pod.getPlaceMark());
        Section section = (Section)this.sectionRepository.getOne((Serializable)((Object)pod.getSectionId()));
        this.rabbitMessageSender.sendMessage(param, section.getName(), "WMS_WCS_POD_ADD_REMOVE");
    }
}

