/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.enums.PodStateEnum;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.common.utils.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PodReserveUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodReserveUtil.class);
    private final PodRepository podRepository;

    @Autowired
    public PodReserveUtil(PodRepository podRepository) {
        this.podRepository = podRepository;
    }

    public synchronized boolean reservePod(Pod pod) {
        boolean result = false;
        if (pod.getState().equalsIgnoreCase(PodStateEnum.AVAILABLE.getName())) {
            pod.setState(PodStateEnum.RESERVED.getName());
            pod = (Pod)this.podRepository.saveAndFlush((Object)pod);
            result = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("reserved pod {} \u6210\u529f\n{}", (Object)pod.getId(), (Object)JSONUtil.toJSon((Object)pod));
            }
        }
        return result;
    }
}

