/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.InvMitemLabel;
import com.mushiny.wms.application.repository.InvMitemLabelRepository;
import com.mushiny.wms.common.utils.CommonUtil;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
public class InvMitemLabelBusiness {
    private Logger LOG = LoggerFactory.getLogger((String)InvMitemLabelBusiness.class.getName());
    @Autowired
    private RestTempConfig restTempConfig;
    private final InvMitemLabelRepository invMitemLabelRepository;
    @Value(value="${midea.webApi.INV_CODE}")
    private String INV_CODE;
    @Value(value="${midea.webApi.INV_ORG_ID}")
    private String INV_ORG_ID;

    @Autowired
    public InvMitemLabelBusiness(InvMitemLabelRepository invMitemLabelRepository) {
        this.invMitemLabelRepository = invMitemLabelRepository;
    }

    public List<InvMitemLabel> saveSfcMitem(List<InvMitemLabel> invMitemLabels) {
        invMitemLabels = CommonUtil.removeSameItem(invMitemLabels, (List)this.invMitemLabelRepository.findAll());
        List result = this.invMitemLabelRepository.save((Iterable)invMitemLabels);
        return result;
    }

    public List<InvMitemLabel> receive(String param) {
        Map tt = JSONUtil.jsonToMap((String)param);
        HashMap paramMap = new HashMap();
        paramMap.put("LAST_UPDATE_DATE", tt.get("LAST_UPDATE_DATE"));
        paramMap.put("INV_ORG_ID", this.INV_ORG_ID);
        paramMap.put("INV_CODE", this.INV_CODE);
        String result = this.restTempConfig.invMitemLabelSyn(paramMap);
        Map resultMap1 = JSONUtil.jsonToMap((String)result);
        List resultMap = (List)resultMap1.get("ListData");
        ArrayList<InvMitemLabel> sfcMitems = new ArrayList<InvMitemLabel>();
        for (Map t : resultMap) {
            InvMitemLabel t2 = (InvMitemLabel)JSONUtil.mapToBean((Map)t, (Object)new InvMitemLabel());
            sfcMitems.add(t2);
        }
        return this.saveSfcMitem(sfcMitems);
    }

    @Scheduled(fixedDelay=3600000L, initialDelay=2000L)
    @Async
    public void execute() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("INV_ORG_ID", this.INV_ORG_ID);
        paramMap.put("INV_CODE", this.INV_CODE);
        Date date = this.invMitemLabelRepository.getLastUpdateDate();
        String ss = "2018-07-01";
        if (!ObjectUtils.isEmpty((Object)date)) {
            ss = DateTimeUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        paramMap.put("LAST_UPDATE_DATE", ss);
        String result = this.restTempConfig.invMitemLabelSyn(paramMap);
        Map resultMap1 = JSONUtil.jsonToMap((String)result);
        List resultMap = (List)resultMap1.get("ListData");
        ArrayList<InvMitemLabel> sfcMitems = new ArrayList<InvMitemLabel>();
        if (!CollectionUtils.isEmpty((Collection)resultMap)) {
            Iterator iterator = resultMap.iterator();
            if (iterator.hasNext()) {
                Map t = (Map)iterator.next();
                InvMitemLabel t2 = (InvMitemLabel)JSONUtil.mapToBean((Map)t, (Object)new InvMitemLabel());
                sfcMitems.add(t2);
            }
            List lml = this.saveSfcMitem(sfcMitems);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Mo\u4fe1\u606f\u540c\u6b65\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)lml));
            }
        } else {
            this.LOG.error("Mo\u4fe1\u606f\u540c\u6b65\u5931\u8d25,\u8fd4\u56de\u4fe1\u606f\n{}", (Object)JSONUtil.toJSon((Object)result));
        }
    }
}

