/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.business.score.StationPodScore;
import com.mushiny.wms.application.domain.Charger;
import com.mushiny.wms.application.domain.Map;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.StationType;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.MapNodeRepository;
import com.mushiny.wms.application.repository.MapRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WCSRobotRepository;
import com.mushiny.wms.common.exception.ApiException;
import com.mushiny.wms.common.exception.ExceptionEnum;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.pathPlanning.utils.MapNodeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
public class CommonBusiness {
    private final TripRepository tripRepository;
    private final PodRepository podRepository;
    private final WCSRobotRepository wcsRobotRepository;
    private final MapNodeRepository mapNodeRepository;
    private final MapRepository mapRepository;
    private final MapNodeUtils mapNodeUtils;
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final EntityManagerUtil entityManagerUtil;
    @Value(value="${mushiny.emptyRun.endAddress.enable}")
    private Boolean enable = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonBusiness.class);

    @Autowired
    public CommonBusiness(TripRepository tripRepository, WCSRobotRepository wcsRobotRepository, MapNodeRepository mapNodeRepository, EntityManagerUtil entityManagerUtil, PodRepository podRepository, SystemPropertyBusiness systemPropertyBusiness, MapRepository mapRepository, MapNodeUtils mapNodeUtils) {
        this.tripRepository = tripRepository;
        this.wcsRobotRepository = wcsRobotRepository;
        this.mapNodeRepository = mapNodeRepository;
        this.podRepository = podRepository;
        this.entityManagerUtil = entityManagerUtil;
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.mapRepository = mapRepository;
        this.mapNodeUtils = mapNodeUtils;
    }

    public List<WCSRobot> getRobotsCanCharged(Section section) {
        int maxLaveBattery = this.systemPropertyBusiness.getDriveOutChargerMinValue(section.getWarehouseId());
        int minLaveBattery = this.systemPropertyBusiness.getDriveInChargerMinValue(section.getWarehouseId());
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        String tripType = TripType.CHARGER_DRIVE.getName();
        return this.wcsRobotRepository.getRobotsCanCharged(tripType, tripStates, section.getId(), minLaveBattery, maxLaveBattery);
    }

    public List<WCSRobot> getRobotsMustCharged(Section section) {
        int minLaveBattery = this.systemPropertyBusiness.getDriveInChargerMinValue(section.getWarehouseId());
        int minValueVoltage = this.systemPropertyBusiness.getRobotVoltageMinValue(section.getWarehouseId());
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        String tripType = TripType.CHARGER_DRIVE.getName();
        return this.wcsRobotRepository.getRobotsMustCharged(tripType, tripStates, section.getId(), minValueVoltage, minLaveBattery);
    }

    public List<WCSRobot> getRobotsVoltageMinValue(Section section) {
        int minLaveBattery = this.systemPropertyBusiness.getRobotVoltageMinValue(section.getWarehouseId());
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        String tripType = TripType.CHARGER_DRIVE.getName();
        return this.wcsRobotRepository.getRobotsVoltageMinValue(tripType, tripStates, section.getId(), minLaveBattery);
    }

    public List<WCSRobot> getSleepAddrRobots(int addr, String sectionId) {
        return this.wcsRobotRepository.getSleepAddrRobots(addr, sectionId);
    }

    public MapNode getChargerNode(Charger charger) {
        Map map = this.mapRepository.getBySectionId(charger.getSectionId());
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.mapNodeRepository.getByAddressCodeId(map.getId(), charger.getPlaceMark().intValue());
        if (chargerNode == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        return chargerNode;
    }

    public MapNode getNodeByPlacemark(String sectionId, Integer addressCodeId) {
        Map map = this.mapRepository.getBySectionId(sectionId);
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.mapNodeRepository.getByAddressCodeId(map.getId(), addressCodeId.intValue());
        if (chargerNode == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        return chargerNode;
    }

    public List<Trip> getAllocatedTrip(Section section) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        return this.tripRepository.getAllocatedTrip(section.getId(), tripStates);
    }

    public Integer getMoveDriveTargetAddress(Charger charger) {
        Map map = this.mapRepository.getBySectionId(charger.getSectionId());
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.getChargerNode(charger);
        List mapNodes = this.mapNodeRepository.getByMapId(map.getId());
        if (mapNodes.isEmpty()) {
            return null;
        }
        MapNode minValueNode = null;
        boolean flag = true;
        for (MapNode mapNode : mapNodes) {
            int minValue;
            List sleepAddrRoots = this.getSleepAddrRobots(mapNode.getAddressCodeId(), map.getSectionId());
            List notFinishEmptRunTrip = this.tripRepository.getSleepAddrRobots(mapNode.getAddressCodeId(), map.getSectionId());
            if (!CollectionUtils.isEmpty((Collection)sleepAddrRoots) || !ObjectUtils.isEmpty((Object)notFinishEmptRunTrip)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("section {} \u4f11\u606f\u533a{} \u6709\u5c0f\u8f66{}\n \u6216\u8005\u6709\u672afinish\u7684EmptRunTrip{}", new Object[]{map.getSectionId(), mapNode.getAddressCodeId(), JSONUtil.toJSon((Object)sleepAddrRoots), JSONUtil.toJSon((Object)notFinishEmptRunTrip)});
                continue;
            }
            if (flag) {
                flag = false;
                minValueNode = mapNode;
                continue;
            }
            int nodeValue = Math.abs(mapNode.getxPosition() - chargerNode.getxPosition()) + Math.abs(mapNode.getyPosition() - chargerNode.getyPosition());
            if (nodeValue >= (minValue = Math.abs(minValueNode.getxPosition() - chargerNode.getxPosition()) + Math.abs(minValueNode.getyPosition() - chargerNode.getyPosition()))) continue;
            minValueNode = mapNode;
        }
        if (!ObjectUtils.isEmpty(minValueNode)) {
            return minValueNode.getAddressCodeId();
        }
        return null;
    }

    public Integer getMoveDriveTargetAddress2(Charger charger) {
        if (!this.enable.booleanValue()) {
            return 0;
        }
        Integer result = null;
        String sql = "SELECT WD_NODE.ADDRESSCODEID,WD_NODE.XPOSITION,WD_NODE.YPOSITION  FROM MD_POD INNER JOIN WD_NODE ON MD_POD.PLACEMARK=WD_NODE.ADDRESSCODEID WHERE MD_POD.ID NOT IN(SELECT DISTINCT IFNULL(RCS_TRIP.POD_ID,'') FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' ) AND MD_POD.PLACEMARK NOT IN (SELECT WCS_ROBOT.ADDRESSCODEID FROM WCS_ROBOT ) AND MD_POD.PLACEMARK NOT IN (SELECT DISTINCT RCS_TRIP.END_ADDRESS FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' AND RCS_TRIP.END_ADDRESS is not null ) AND MAP_ID=:mapId AND WD_NODE.TYPE=1 order by WD_NODE.ADDRESSCODEID";
        Map map = this.mapRepository.getBySectionId(charger.getSectionId());
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.getChargerNode(charger);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mapId", map.getId());
        List results = this.entityManagerUtil.executeNativeQuery(sql, param);
        java.util.Map minValueNode = null;
        boolean flag = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section {}\u5c0f\u8f66\u5145\u7535\u7ed3\u675f\u53ef\u4ee5\u53bb\u7684\u4f4d\u7f6e{}\n ", (Object)charger.getName(), (Object)JSONUtil.toJSon((Object)results));
        }
        HashMap cal = new HashMap();
        for (java.util.Map temp : results) {
            int minValue;
            if (minValueNode == null) {
                minValueNode = temp;
                continue;
            }
            int nodeValue = Math.abs(Integer.valueOf((Integer)temp.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)temp.get("YPOSITION")) - chargerNode.getyPosition());
            if (nodeValue >= (minValue = Math.abs(Integer.valueOf((Integer)minValueNode.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)minValueNode.get("YPOSITION")) - chargerNode.getyPosition()))) continue;
            minValueNode = temp;
        }
        if (minValueNode != null) {
            result = (int)((Integer)minValueNode.get("ADDRESSCODEID"));
        }
        return result;
    }

    public Integer getMoveDriveTargetAddress3(String sectionId, Integer address) {
        if (!this.enable.booleanValue()) {
            return 0;
        }
        Integer result = null;
        String sql = "SELECT WD_NODE.ADDRESSCODEID,WD_NODE.XPOSITION,WD_NODE.YPOSITION  FROM MD_POD INNER JOIN WD_NODE ON MD_POD.PLACEMARK=WD_NODE.ADDRESSCODEID WHERE MD_POD.ID NOT IN(SELECT DISTINCT IFNULL(RCS_TRIP.POD_ID,'') FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' ) AND MD_POD.PLACEMARK NOT IN (SELECT WCS_ROBOT.ADDRESSCODEID FROM WCS_ROBOT ) AND MD_POD.PLACEMARK NOT IN (SELECT DISTINCT RCS_TRIP.END_ADDRESS FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' AND RCS_TRIP.END_ADDRESS is not null ) AND MAP_ID=:mapId AND WD_NODE.TYPE=1 order by WD_NODE.ADDRESSCODEID";
        Map map = this.mapRepository.getBySectionId(sectionId);
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.getNodeByPlacemark(sectionId, address);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mapId", map.getId());
        List results = this.entityManagerUtil.executeNativeQuery(sql, param);
        java.util.Map minValueNode = null;
        boolean flag = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section {}\u5c0f\u8f66\u5145\u7535\u7ed3\u675f\u53ef\u4ee5\u53bb\u7684\u4f4d\u7f6e{}\n ", (Object)sectionId, (Object)JSONUtil.toJSon((Object)results));
        }
        HashMap cal = new HashMap();
        for (java.util.Map temp : results) {
            int minValue;
            if (minValueNode == null) {
                minValueNode = temp;
                continue;
            }
            int nodeValue = Math.abs(Integer.valueOf((Integer)temp.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)temp.get("YPOSITION")) - chargerNode.getyPosition());
            if (nodeValue >= (minValue = Math.abs(Integer.valueOf((Integer)minValueNode.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)minValueNode.get("YPOSITION")) - chargerNode.getyPosition()))) continue;
            minValueNode = temp;
        }
        if (minValueNode != null) {
            result = (int)((Integer)minValueNode.get("ADDRESSCODEID"));
        }
        return result;
    }

    public Trip getTripByWCSRobot(WCSRobot wcsRobot) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        return this.tripRepository.getByRobotId(wcsRobot.getRobotId(), tripStates);
    }

    public Trip getTripByCharger(Charger charger) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        return this.tripRepository.getByChargerId(charger.getId(), tripStates);
    }

    public List<Trip> getAllNewTrip(String sectionId) {
        ArrayList<String> tripTypes = new ArrayList<String>();
        tripTypes.add(TripType.PICK_POD.getName());
        tripTypes.add(TripType.STOW_POD.getName());
        tripTypes.add(TripType.IBP_POD.getName());
        tripTypes.add(TripType.OBP_POD.getName());
        tripTypes.add(TripType.ICQA_POD.getName());
        tripTypes.add(TripType.POD_SCAN.getName());
        tripTypes.add(TripType.POD_RUN.getName());
        tripTypes.add(TripType.LMGETMATERIAL.getName());
        tripTypes.add(TripType.ANNTOMVOUT.getName());
        tripTypes.add(TripType.FINISHESWAREHOUSING.getName());
        tripTypes.add(TripType.CARRY_POD.getName());
        tripTypes.add(TripType.ANNTO_MVIN.getName());
        tripTypes.add(TripType.CHARGER_DRIVE.getName());
        String tripState = TripState.NEW.getName();
        return this.tripRepository.getAllNewTrips(tripTypes, tripState, sectionId);
    }

    public boolean canGenerateEmptRun(String sectionId, String driveId) {
        boolean result;
        List trips = this.getAllNotChargeTrips(sectionId, driveId);
        List temp = this.getAllEmptyRunTrips(sectionId, driveId);
        List newTrips = this.getAllNotChargeNewTrips(sectionId);
        List chargeTrips = this.getRobotChargeTrip(sectionId, driveId);
        boolean bl = result = ObjectUtils.isEmpty((Object)temp) && CollectionUtils.isEmpty((Collection)trips) && CollectionUtils.isEmpty((Collection)chargeTrips);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5c0f\u8f66{}\u5206\u914d\u4efb\u52a1{}\n\u751f\u6210\u8c03\u8d70\u5c0f\u8f66\u7684\u4efb\u52a1{}\n\u65b0\u751f\u6210\u7684\u8c03\u5ea6\u5355{}\n\u5145\u7535\u8c03\u5ea6\u5355{}\n", new Object[]{driveId, JSONUtil.toJSon((Object)trips), JSONUtil.toJSon((Object)temp), JSONUtil.toJSon((Object)newTrips), JSONUtil.toJSon((Object)chargeTrips)});
        }
        if (!result) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5c0f\u8f66\u4e0d\u53ef\u4ee5\u8c03\u8d70,\u5df2\u7ecf\u751f\u6210\u6389\u8d70\u5355\u6216\u8005\u5df2\u7ecf\u5206\u914d\u4efb\u52a1\u6216\u8005\u5145\u7535\u5355\u6ca1\u6709\u7ed3\u675f", (Object)driveId);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5c0f\u8f66{}\u53ef\u4ee5\u8c03\u8d70", (Object)driveId);
        }
        return result;
    }

    public List<Trip> getAllNotChargeTrips(String sectionId, String driveId) {
        ArrayList<String> tripTypes = new ArrayList<String>();
        tripTypes.add(TripType.CHARGER_DRIVE.getName());
        String tripState = TripState.FINISHED.getName();
        return this.tripRepository.getAllNotChargeTrips(tripTypes, tripState, sectionId, driveId);
    }

    public List<Trip> getAllNotChargeNewTrips(String sectionId) {
        ArrayList<String> tripTypes = new ArrayList<String>();
        tripTypes.add(TripType.CHARGER_DRIVE.getName());
        String tripState = TripState.NEW.getName();
        return this.tripRepository.getAllNotChargenNewTrips(tripTypes, tripState, sectionId);
    }

    public List<Trip> getAllEmptyRunTrips(String sectionId, String dri) {
        ArrayList<String> tripState = new ArrayList<String>();
        tripState.add(TripState.NEW.getName());
        tripState.add(TripState.AVAILABLE.getName());
        tripState.add(TripState.PROCESS.getName());
        tripState.add(TripState.LEAVING.getName());
        return this.tripRepository.getAllEmptyRunTrips(dri, tripState, sectionId);
    }

    public List<WCSRobot> getAvailableDrives(String sectionId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        return this.wcsRobotRepository.getAvailableDrives(tripStates, sectionId);
    }

    public List<WCSRobot> getAvailableDrives2(String sectionId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        return this.wcsRobotRepository.getDrives(tripStates, sectionId, Arrays.asList(StationType.OUTBOUNDAUTO, StationType.OUTBOUNDMANUL));
    }

    public List<Trip> getTrip(String podId, String sectionId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        List result = this.tripRepository.getTripsByPodId(tripStates, podId, sectionId);
        return result;
    }

    public List<Trip> getRobotChargeTrip(String sectionId, String driveId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.NEW.getName());
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        List result = this.tripRepository.getRobotChargeTrip(sectionId, driveId, tripStates);
        return result;
    }

    public boolean tripsAddrcodeIdInPlaceMark(String placeMark, String sectionId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.PROCESS.getName());
        List trip = this.tripRepository.getTripsAddrcodeId(tripStates, placeMark, sectionId);
        return !CollectionUtils.isEmpty((Collection)trip);
    }

    public List<Pod> releasedTrargetPod(String tarAddrid, String sectionId) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.LEAVING.getName());
        tripStates.add(TripState.PROCESS.getName());
        List pod = this.podRepository.getByTripTarAddrId(tripStates, tarAddrid, sectionId);
        return pod;
    }

    public List<Trip> checkingDriveCanUse(Trip trip) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        List result = this.tripRepository.getWorkStationTrip(tripStates, trip.getSectionId(), trip.getTripType(), trip.getWorkStationId());
        return result;
    }

    public boolean checkingDriveCanUse(String robotId, Trip trip) {
        ArrayList<String> tripStates = new ArrayList<String>();
        tripStates.add(TripState.AVAILABLE.getName());
        tripStates.add(TripState.PROCESS.getName());
        tripStates.add(TripState.LEAVING.getName());
        Trip result = this.tripRepository.getAvailableTrip(tripStates, trip.getId());
        WCSRobot wcsRobot = this.wcsRobotRepository.getAvailableDrive(tripStates, robotId);
        List emptyDetail = this.getEmptyRunEndAddressPod(trip.getId());
        String wcsRobot2 = this.getRobotByPod(trip.getPodId());
        LOGGER.info("\u662f\u5426\u5df2\u7ecf\u5b58\u5728 pod{}\u8c03\u5ea6\u5355{}", (Object)trip.getPodId(), (Object)(result != null ? 1 : 0));
        LOGGER.info("\u5c0f\u8f66{} \u662f\u5426\u53ef\u7528{}", (Object)robotId, (Object)(wcsRobot != null ? 1 : 0));
        LOGGER.info("pod{} \u4e0b\u7684\u5c0f\u8f66{}", (Object)trip.getPodId(), (Object)wcsRobot2);
        if (!CollectionUtils.isEmpty((Collection)emptyDetail)) {
            LOGGER.info("\u8c03\u5ea6\u5355 {} pod {}  \u5730\u5740 {} \u6709\u5145\u7535\u5c0f\u8f66\u8fc7\u53bb", new Object[]{trip.getId(), ((java.util.Map)emptyDetail.get(0)).get("POD_INDEX"), ((java.util.Map)emptyDetail.get(0)).get("PLACEMARK")});
        }
        return wcsRobot2 == null && result == null && wcsRobot != null && CollectionUtils.isEmpty((Collection)emptyDetail) || wcsRobot2 != null && wcsRobot2.equals(robotId);
    }

    public String getRobotByPod(String podId) {
        String wcsRobot = null;
        String sql = "select WCS_ROBOT.* from WCS_ROBOT inner join MD_POD on MD_POD.PLACEMARK= WCS_ROBOT.ADDRESSCODEID and WCS_ROBOT.ADDRESSCODEID<>0 and WCS_ROBOT.SECTION_ID=MD_POD.SECTION_ID and MD_POD.id=:podId ";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("podId", podId);
        List wcsRobots = this.entityManagerUtil.executeNativeQuery(sql, param);
        if (!CollectionUtils.isEmpty((Collection)wcsRobots)) {
            wcsRobot = (String)((java.util.Map)wcsRobots.get(0)).get("ROBOT_ID");
        }
        return wcsRobot;
    }

    List<java.util.Map> getEmptyRunEndAddressPod(String tripId) {
        String sql = "SELECT MD_POD.POD_INDEX,MD_POD.PLACEMARK,T1.ID FROM MD_POD  INNER JOIN RCS_TRIP T1 ON T1.POD_ID=MD_POD.ID WHERE T1.ID=:tripId AND MD_POD.PLACEMARK  IN (SELECT T2.END_ADDRESS FROM RCS_TRIP T2 WHERE  T2.TRIP_STATE!='FINISH' AND T2.TRIP_TYPE='EmptyRun' AND T2.END_ADDRESS IS NOT NULL )";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tripId", tripId);
        List trips = this.entityManagerUtil.executeNativeQuery(sql, param);
        return trips;
    }

    public MapNode findMapNodeBySectionId(String sectionId, Integer placeMark) {
        Map map = this.mapRepository.getBySectionId(sectionId);
        MapNode podNode = this.mapNodeUtils.findMapNode(map.getId(), placeMark.intValue());
        return podNode;
    }

    public List<StationPodScore> getPodScore(List<Pod> pods, MdStationnodeposition stationPosition) {
        ArrayList<StationPodScore> podScores = new ArrayList<StationPodScore>();
        Map map = this.mapRepository.getBySectionId(stationPosition.getStationnode().getSectionId());
        for (Pod p : pods) {
            MapNode podNode = this.findMapNodeBySectionId(stationPosition.getStationnode().getSectionId(), p.getPlaceMark());
            StationPodScore ep = new StationPodScore();
            int sc = Math.abs(stationPosition.getNode().getxPosition() - podNode.getxPosition()) + Math.abs(stationPosition.getNode().getyPosition() - podNode.getyPosition());
            ep.setPod(p);
            ep.setStationnodeposition(stationPosition);
            ep.setScore(Integer.valueOf(sc));
            podScores.add(ep);
        }
        podScores.sort(Comparator.comparing(StationPodScore::getScore));
        return podScores;
    }

    public List<StationPodScore> getStationPodScore(List<MdStationnodeposition> stations, Pod pod) {
        ArrayList<StationPodScore> stationScores = new ArrayList<StationPodScore>();
        for (MdStationnodeposition sp : stations) {
            StationPodScore ep = new StationPodScore();
            int sc = Math.abs(sp.getNode().getxPosition() - pod.getxPos()) + Math.abs(sp.getNode().getyPosition() - pod.getyPos());
            ep.setPod(pod);
            ep.setStationnodeposition(sp);
            ep.setScore(Integer.valueOf(sc));
            stationScores.add(ep);
        }
        stationScores.sort(Comparator.comparing(StationPodScore::getScore));
        return stationScores;
    }

    public Integer getTargetAddress(String sectionId, Integer addressCodeId) {
        Integer result = null;
        String sql = "SELECT WD_NODE.ADDRESSCODEID,WD_NODE.XPOSITION,WD_NODE.YPOSITION  FROM MD_POD INNER JOIN WD_NODE ON MD_POD.PLACEMARK=WD_NODE.ADDRESSCODEID WHERE MD_POD.ID NOT IN(SELECT DISTINCT IFNULL(RCS_TRIP.POD_ID,'') FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' ) AND MD_POD.PLACEMARK NOT IN (SELECT WCS_ROBOT.ADDRESSCODEID FROM WCS_ROBOT ) AND MD_POD.PLACEMARK NOT IN (SELECT DISTINCT RCS_TRIP.END_ADDRESS FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE!='Finish' AND RCS_TRIP.END_ADDRESS is not null ) AND MAP_ID=:mapId AND WD_NODE.TYPE=1 order by WD_NODE.ADDRESSCODEID";
        Map map = this.mapRepository.getBySectionId(sectionId);
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        MapNode chargerNode = this.getNodeByPlacemark(sectionId, addressCodeId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("mapId", map.getId());
        List results = this.entityManagerUtil.executeNativeQuery(sql, param);
        java.util.Map minValueNode = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section {}\u5c0f\u8f66SLAM\u51fa\u5e93\u7ed3\u675f\u53ef\u4ee5\u53bb\u7684\u4f4d\u7f6e{}\n ", (Object)sectionId, (Object)JSONUtil.toJSon((Object)results));
        }
        for (java.util.Map temp : results) {
            if (minValueNode == null) {
                minValueNode = temp;
                continue;
            }
            int nodeValue = Math.abs(Integer.valueOf((Integer)temp.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)temp.get("YPOSITION")) - chargerNode.getyPosition());
            int minValue = Math.abs(Integer.valueOf((Integer)minValueNode.get("XPOSITION")) - chargerNode.getxPosition()) + Math.abs(Integer.valueOf((Integer)minValueNode.get("YPOSITION")) - chargerNode.getyPosition());
            if (nodeValue < 10 || nodeValue >= minValue) continue;
            minValueNode = temp;
        }
        if (minValueNode != null) {
            result = (int)((Integer)minValueNode.get("ADDRESSCODEID"));
        }
        return result;
    }
}

