/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.common;

import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.TripRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
public class BuildEntityBusiness {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildEntityBusiness.class);
    @Autowired
    private TripRepository tripRepository;

    public Trip buildTrip(Pod pod, MdStationnodeposition workStation, Object instruct, TripType tripType) {
        LOGGER.debug("\u751f\u6210\u8c03\u5ea6\u5355{} pod {} MdStationnodeposition {} instruct {} tripType {}", new Object[]{pod.getPodIndex(), workStation, instruct, tripType});
        String instructDefault = "";
        String stationId = "";
        String stationNodePositionId = "";
        if (!ObjectUtils.isEmpty((Object)workStation)) {
            stationId = workStation.getStationnode().getId();
            stationNodePositionId = workStation.getId();
        }
        instructDefault = !ObjectUtils.isEmpty((Object)instruct) && instruct instanceof InboundInstruct ? ((InboundInstruct)instruct).getId() : (!ObjectUtils.isEmpty((Object)instruct) && instruct instanceof OutboundInstruct ? ((OutboundInstruct)instruct).getId() : "");
        Trip trip = new Trip();
        trip.setTripType(tripType.getName());
        trip.setTripState(TripState.NEW.getName());
        trip.setPodId(pod.getId());
        trip.setInstruct(instructDefault);
        trip.setWorkStationId(stationId);
        trip.setMdNodePosition(stationNodePositionId);
        trip.setSectionId(pod.getSectionId());
        trip.setWarehouseId(pod.getWarehouseId());
        trip = (Trip)this.tripRepository.saveAndFlush((Object)trip);
        LOGGER.debug("\u751f\u6210\u6307\u4ee4{} pod {} workStation {} Stationnodeposition {}trip {}", new Object[]{instructDefault, pod.getPodIndex(), stationId, stationNodePositionId, trip.getId()});
        return trip;
    }

    public Trip buildSlamTrip(Pod pod, MdStationnodeposition workStation, Object instruct, TripType tripType) {
        String instructDefault = "";
        String stationId = "";
        String stationNodePositionId = "";
        if (!ObjectUtils.isEmpty((Object)workStation)) {
            stationId = workStation.getStationnode().getId();
            stationNodePositionId = workStation.getId();
        }
        instructDefault = !ObjectUtils.isEmpty((Object)instruct) && instruct instanceof InboundInstruct ? ((InboundInstruct)instruct).getId() : (!ObjectUtils.isEmpty((Object)instruct) && instruct instanceof OutboundInstruct ? ((OutboundInstruct)instruct).getId() : "");
        Trip trip = new Trip();
        trip.setTripType(tripType.getName());
        trip.setTripState(TripState.NEW.getName());
        trip.setPodId(pod.getId());
        trip.setInstruct(instructDefault);
        trip.setWorkStationId(stationId);
        trip.setMdNodePosition(stationNodePositionId);
        trip.setSectionId(pod.getSectionId());
        trip.setWarehouseId(pod.getWarehouseId());
        trip = (Trip)this.tripRepository.saveAndFlush((Object)trip);
        LOGGER.debug("\u751f\u6210\u6307\u4ee4{} pod {} workStation {} Stationnodeposition {}trip {}", new Object[]{instructDefault, pod.getPodIndex(), stationId, stationNodePositionId, trip.getId()});
        return trip;
    }
}

