/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.business.dto.RobotChargerScore;
import com.mushiny.wms.application.business.score.RobotChargerScoreBusiness;
import com.mushiny.wms.application.domain.Charger;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.ChargeType;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.ChargerRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WCSRobotRepository;
import com.mushiny.wms.common.utils.JSONUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
public class ChargerAllocationBusiness {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargerAllocationBusiness.class);
    private final CommonBusiness commonBusiness;
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final RobotChargerScoreBusiness robotChargerScoreBusiness;
    private final ChargerRepository chargerRepository;
    private final TripRepository tripRepository;
    private final WCSRobotRepository wcsRobotRepository;
    @Value(value="${mushiny.robot3.begain.index}")
    private Integer robot3Are = 50;
    private List<String> gloableTemp = new ArrayList();

    @Autowired
    public ChargerAllocationBusiness(CommonBusiness commonBusiness, ChargerRepository chargerRepository, TripRepository tripRepository, WCSRobotRepository wcsRobotRepository, SystemPropertyBusiness systemPropertyBusiness, RobotChargerScoreBusiness robotChargerScoreBusiness) {
        this.commonBusiness = commonBusiness;
        this.chargerRepository = chargerRepository;
        this.tripRepository = tripRepository;
        this.wcsRobotRepository = wcsRobotRepository;
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.robotChargerScoreBusiness = robotChargerScoreBusiness;
    }

    public void runChargerAllocation(Section section) {
        List availableChargers = this.chargerRepository.getAvailableChargers(section.getId());
        if (availableChargers.isEmpty()) {
            LOGGER.info("section  {} \u65e0\u53ef\u7528\u7684\u5145\u7535\u6869,\u5145\u7535\u6869\u51fa\u73b0\u6545\u969c", (Object)section.getName());
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section  {} \u5145\u7535\u6869{}", (Object)section.getName(), (Object)JSONUtil.toJSon((Object)availableChargers));
        }
        ArrayList<Charger> chargers = new ArrayList<Charger>();
        for (Charger availableCharger : availableChargers) {
            boolean canBuild;
            WCSRobot fullLaveBatteryRobot = this.wcsRobotRepository.getByAddressCodeId(availableCharger.getPlaceMark().intValue(), availableCharger.getSectionId());
            if (fullLaveBatteryRobot == null) {
                Trip trip = this.commonBusiness.getTripByCharger(availableCharger);
                if (trip != null || !availableCharger.getState().equals("Available")) continue;
                chargers.add(availableCharger);
                continue;
            }
            int driveChargerFull = this.systemPropertyBusiness.getDriveChargerFullValue(availableCharger.getWarehouseId());
            int robotVoltageMaxValue = this.systemPropertyBusiness.getRobotVoltageMaxValue(availableCharger.getWarehouseId());
            int robotVoltageMinValue = this.systemPropertyBusiness.getRobotVoltageMinValue(availableCharger.getWarehouseId());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("section  {} \u5145\u7535\u6869{} \u4e0b\u5c0f\u8f66 {} \u5728\u5145\u7535", new Object[]{section.getName(), availableCharger.getName(), fullLaveBatteryRobot.getRobotId()});
                LOGGER.debug("\u5c0f\u8f66 {} \u5f53\u524d\u7535\u91cf{} \u8981\u6c42\u6700\u5927\u7535\u91cf{} \u5f53\u524d\u7535\u538b{} \u6700\u5c0f\u7535\u538b{} \u6700\u5c0f\u7535\u538b{} ", new Object[]{fullLaveBatteryRobot.getRobotId(), fullLaveBatteryRobot.getLaveBattery(), driveChargerFull, fullLaveBatteryRobot.getVoltage(), robotVoltageMinValue, robotVoltageMaxValue});
            }
            if (fullLaveBatteryRobot.getVoltage() != null && fullLaveBatteryRobot.getVoltage() >= robotVoltageMaxValue) {
                LOGGER.debug("\u5c0f\u8f66 {} \u7535\u538b{} \u5927\u4e8e \u7cfb\u7edf\u8bbe\u7f6e\u6700\u5927\u7535\u538b{}", new Object[]{fullLaveBatteryRobot.getRobotId(), fullLaveBatteryRobot.getVoltage(), robotVoltageMaxValue});
                canBuild = this.commonBusiness.canGenerateEmptRun(section.getId(), fullLaveBatteryRobot.getRobotId());
                if (!canBuild) continue;
                this.buildMoveRobotTrip(availableCharger, fullLaveBatteryRobot);
                continue;
            }
            if (fullLaveBatteryRobot.getLaveBattery() >= driveChargerFull && fullLaveBatteryRobot.getVoltage() > robotVoltageMinValue && fullLaveBatteryRobot.getVoltage() < robotVoltageMaxValue) {
                canBuild = this.commonBusiness.canGenerateEmptRun(section.getId(), fullLaveBatteryRobot.getRobotId());
                if (!canBuild) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u5c0f\u8f66 {} \u53ef\u4ee5\u8c03\u8d70", (Object)fullLaveBatteryRobot.getRobotId());
                }
                this.buildMoveRobotTrip(availableCharger, fullLaveBatteryRobot);
                this.buildMustMoveRobotTrip(section, fullLaveBatteryRobot, availableCharger);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("\u5c0f\u8f66 {} \u7535\u538b\u4e0d\u6ee1\u8db3\u8c03\u8d70\u6761\u4ef6", (Object)fullLaveBatteryRobot.getRobotId());
        }
        if (chargers.isEmpty()) {
            return;
        }
        List robots = this.commonBusiness.getRobotsMustCharged(section);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section  {} \u5fc5\u987b\u53bb\u5145\u7535\u7684\u5c0f\u8f66{}", (Object)section.getName(), (Object)JSONUtil.toJSon((Object)robots));
        }
        ArrayList<Charger> chargerType2 = new ArrayList<Charger>();
        ArrayList<Charger> chargerType3 = new ArrayList<Charger>();
        ArrayList<WCSRobot> type2Robot = new ArrayList<WCSRobot>();
        ArrayList<WCSRobot> type3Robot = new ArrayList<WCSRobot>();
        for (Charger cg : chargers) {
            if (cg.getChargerType() == ChargeType.MUSHINY_2.getType() || ChargeType.MEIDI.getType() == cg.getChargerType()) {
                chargerType2.add(cg);
                continue;
            }
            chargerType3.add(cg);
        }
        for (WCSRobot wr : robots) {
            if (Integer.parseInt(wr.getRobotId()) > this.robot3Are) {
                type3Robot.add(wr);
                continue;
            }
            type2Robot.add(wr);
        }
        this.buildMustChargerTrip(type2Robot, chargerType2);
        this.buildMustChargerTrip(type3Robot, chargerType3);
        robots = this.commonBusiness.getRobotsCanCharged(section);
        type2Robot.clear();
        type3Robot.clear();
        for (WCSRobot wr : robots) {
            if (Integer.parseInt(wr.getRobotId()) > this.robot3Are) {
                type3Robot.add(wr);
                continue;
            }
            type2Robot.add(wr);
        }
        this.buildCanChargerTrip(type2Robot, chargerType2, section);
        this.buildCanChargerTrip(type3Robot, chargerType3, section);
    }

    private void buildCanChargerTrip(List<WCSRobot> robots, List<Charger> chargers, Section section) {
        if (!CollectionUtils.isEmpty(robots) && !CollectionUtils.isEmpty(chargers)) {
            List robotChargerScores = this.robotChargerScoreBusiness.getScores(chargers, robots, section.getWarehouseId());
            robotChargerScores.sort(Comparator.comparing(RobotChargerScore::getScore));
            ArrayList<String> usedRobotIds = new ArrayList<String>();
            ArrayList<String> usedChargerIds = new ArrayList<String>();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u9700\u8981\u5145\u7535\u7684\u5c0f\u8f66\u6392\u5e8f\n {} ", (Object)JSONUtil.toJSon((Object)robotChargerScores));
            }
            for (RobotChargerScore robotChargerScore : robotChargerScores) {
                Optional<String> usedRobotId;
                Optional<String> usedPodId = usedChargerIds.stream().filter(str -> str.equalsIgnoreCase(robotChargerScore.getCharger().getId())).findFirst();
                if (usedPodId.isPresent() || (usedRobotId = usedRobotIds.stream().filter(str -> str.equalsIgnoreCase(robotChargerScore.getRobot().getId())).findFirst()).isPresent()) continue;
                this.buildChargerAllocationTrip(robotChargerScore.getCharger(), robotChargerScore.getRobot());
                usedChargerIds.add(robotChargerScore.getCharger().getId());
                usedRobotIds.add(robotChargerScore.getRobot().getId());
            }
        }
    }

    private void buildMustChargerTrip(List<WCSRobot> robots, List<Charger> chargers) {
        if (!CollectionUtils.isEmpty(robots) && !CollectionUtils.isEmpty(chargers)) {
            for (WCSRobot robot : robots) {
                BigDecimal chargerValue = BigDecimal.ZERO;
                Charger robotCharger = null;
                boolean chargerFlag = false;
                for (Charger charger : chargers) {
                    MapNode mapNode = this.commonBusiness.getChargerNode(charger);
                    BigDecimal value = BigDecimal.valueOf(Math.abs(robot.getxPosition() - mapNode.getxPosition()) + Math.abs(robot.getyPosition() - mapNode.getyPosition()));
                    if (!chargerFlag) {
                        chargerFlag = true;
                        chargerValue = value;
                        robotCharger = charger;
                        continue;
                    }
                    if (value.compareTo(chargerValue) >= 0) continue;
                    chargerValue = value;
                    robotCharger = charger;
                }
                if (!chargerFlag) continue;
                this.buildChargerAllocationTrip(robotCharger, robot);
                chargers.remove(robotCharger);
                if (!chargers.isEmpty()) continue;
                return;
            }
        }
    }

    private void buildChargerAllocationTrip(Charger charger, WCSRobot robot) {
        Trip trip = new Trip();
        trip.setTripType(TripType.CHARGER_DRIVE.getName());
        trip.setTripState(TripState.NEW.getName());
        trip.setChargerId(charger.getId());
        trip.setDriveId(robot.getRobotId());
        trip.setSectionId(charger.getSectionId());
        trip.setWarehouseId(charger.getWarehouseId());
        trip = (Trip)this.tripRepository.saveAndFlush((Object)trip);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u751f\u6210\u5c0f\u8f66{} \u8c03\u5ea6\u5355 {} \u5c0f\u8f66\u7535\u91cf {} ", new Object[]{robot.getRobotId(), trip.getId(), robot.getLaveBattery()});
        }
    }

    private void buildMoveRobotTrip(Charger charger, WCSRobot wcsRobot) {
        Integer moveTargetAddress = this.commonBusiness.getMoveDriveTargetAddress2(charger);
        if (moveTargetAddress == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("section {} \u5c0f\u8f66{}\u65e0\u53ef\u7528\u7684\u4f11\u606f\u533a", (Object)wcsRobot.getSectionId(), (Object)wcsRobot.getRobotId());
            }
            return;
        }
        Trip moveTrip = new Trip();
        moveTrip.setTripType(TripType.MOVE_DRIVE.getName());
        moveTrip.setTripState(TripState.AVAILABLE.getName());
        moveTrip.setDriveId(wcsRobot.getRobotId());
        moveTrip.setEndAddress(moveTargetAddress);
        moveTrip.setSectionId(charger.getSectionId());
        moveTrip.setWarehouseId(charger.getWarehouseId());
        moveTrip = (Trip)this.tripRepository.saveAndFlush((Object)moveTrip);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u751f\u6210\u5c0f\u8f66 {} \u8c03\u8d70\u7684\u8c03\u5ea6\u5355{}\u6210\u529f", (Object)wcsRobot.getRobotId(), (Object)moveTrip.getId());
        }
    }

    private void buildMustMoveRobotTrip(Section section, WCSRobot wcsRobot, Charger availableCharger) {
        List canUse = this.wcsRobotRepository.driverCanUse(wcsRobot.getRobotId(), section.getId());
        if (!CollectionUtils.isEmpty((Collection)canUse)) {
            List robots = this.commonBusiness.getRobotsMustCharged(section);
            if (!ObjectUtils.isEmpty((Object)robots)) {
                for (WCSRobot wr : robots) {
                    this.gloableTemp.add(wr.getRobotId());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}\u5b58\u5728\u5fc5\u987b\u53bb\u5145\u7535\u7684\u5c0f\u8f66{} \u5c06\u5145\u7535\u5c0f\u8f66{}\u8c03\u8d70", (Object)section.getName(), (Object)JSONUtil.toJSon((Object)this.gloableTemp));
                }
                this.gloableTemp.clear();
                LOGGER.info("\u5f00\u59cb\u751f\u6210\u5f3a\u5236\u8c03\u8d70\u5c0f\u8f66\u5f00\u59cb");
                this.buildMoveRobotTrip(availableCharger, wcsRobot);
                LOGGER.info("\u5f3a\u5236\u8c03\u8d70\u5c0f\u8f66\u7ed3\u675f");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}\u6ca1\u6709\u5fc5\u987b\u53bb\u5145\u7535\u7684\u5c0f\u8f66,\u4e0d\u751f\u6210\u8c03\u5ea6\u5355", (Object)section.getName());
            }
        } else {
            LOGGER.info("\u4e0d\u9700\u8981\u5f3a\u5236\u8c03\u8d70{}\u65f6\u5c0f\u8f66\u72b6\u6001{}", (Object)wcsRobot.getRobotId(), (Object)JSONUtil.toJSon((Object)wcsRobot));
        }
    }
}

