/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms;

import com.mushiny.wms.ServerApplicationExceptionHandler;
import com.mushiny.wms.common.context.ApplicationBeanContextAware;
import com.mushiny.wms.common.context.ApplicationContext;
import com.mushiny.wms.common.utils.JSONUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ServerApplicationExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerApplicationExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleException(HttpServletRequest request, Throwable ex) {
        HttpStatus httpStatus = this.getStatus(request);
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = uri + '?' + request.getQueryString();
        }
        String url = String.format("%s %s", request.getMethod(), uri);
        ApplicationContext applicationContext = (ApplicationContext)ApplicationBeanContextAware.getBean(ApplicationContext.class);
        Message me = new Message(this, null);
        me.setCode("0");
        me.setMessage("fail");
        me.setDescribe(ex.toString() + ex.getMessage());
        String message = JSONUtil.toJSon((Object)me);
        LOG.error("##############################Start##############################");
        LOG.error(url);
        LOG.error(message, ex);
        LOG.error("###############################End###############################");
        return new ResponseEntity((Object)message, httpStatus);
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }
}

