/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.interceptor;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RepositoryMethodAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryMethodAspect.class);
    public static final String POINT = "execution(* com.mushiny.wms.application.repository.*.*(..))";
    private static final long ONE_MINUTE = 10L;

    @Around(value="execution(* com.mushiny.wms.application.repository.*.*(..))")
    public Object timeAround(ProceedingJoinPoint joinPoint) {
        Object obj = null;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
        LOGGER.info("\u5f00\u59cb\u6267\u884c\u67e5\u8be2[" + methodName + "]");
        try {
            obj = joinPoint.proceed();
        }
        catch (Throwable e) {
            LOGGER.error("\u7edf\u8ba1\u67d0\u65b9\u6cd5\u6267\u884c\u8017\u65f6\u73af\u7ed5\u901a\u77e5\u51fa\u9519", e);
        }
        return obj;
    }
}

