/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.interceptor;

import com.mushiny.wms.common.utils.JSONUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ControlerParamAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlerParamAspect.class);
    public static final String POINT = "execution(* com.mushiny.wms.*.web.*.*(..)))";

    @Around(value="execution(* com.mushiny.wms.*.web.*.*(..)))")
    public Object timeAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj = null;
        Object[] args = joinPoint.getArgs();
        StringBuffer sb = new StringBuffer();
        for (Object arg : args) {
            sb.append(arg);
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
        LOGGER.info("web\u8bf7\u6c42,\u65b9\u6cd5\u540d{} \u53c2\u6570{}", (Object)methodName, (Object)sb.toString());
        try {
            obj = joinPoint.proceed(args);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            throw e;
        }
        LOGGER.info("web\u8bf7\u6c42,\u65b9\u6cd5\u540d{} \u8fd4\u56de{}", (Object)methodName, (Object)JSONUtil.toJSon((Object)obj));
        return obj;
    }
}

