package com.mushiny.wms.slam;

import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.common.utils.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 电梯配置
 */
@RestController
@RequestMapping("/slam")
public class SlamTripController {
    private static final Logger logger = LoggerFactory.getLogger(SlamTripController.class);
    private final SlamTripService slamTripService;

    public SlamTripController(SlamTripService slamTripService) {
        this.slamTripService = slamTripService;
    }

    @PostMapping(value = "/agvError", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MushinyMessage> agvError(@RequestBody String agvErrorMsg) {
        Integer result = 0;
        String message = "success";
        try {
            this.slamTripService.agvError(agvErrorMsg);
        } catch (Exception e) {
            result = 1;
            logger.error(e.getMessage(), e);
            message = e.getMessage();
        }

        MushinyMessage mm = new MushinyMessage();
        mm.setCode(result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok(mm);
    }

    @PostMapping(value = "/agvTaskConfirm", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MushinyMessage> agvTaskConfirm(@RequestBody String taskConfirm) {
        Integer result = 0;
        String message = "success";
        try {
            this.slamTripService.agvTaskConfirm(taskConfirm);
        } catch (Exception e) {
            result = 1;
            logger.error(e.getMessage(), e);
            message = e.getMessage();
        }

        MushinyMessage mm = new MushinyMessage();
        mm.setCode(result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok(mm);
    }

    @GetMapping(path = "/agvTaskSelect")
    public String agvTaskSelect(HttpServletRequest request, HttpServletResponse response) {
        String taskId = request.getParameter("taskId");
        return this.slamTripService.agvTaskSelect(taskId);
    }

    /*@GetMapping(path = "/agvTaskFinish")
    public String agvTaskFinish(HttpServletRequest request, HttpServletResponse response) {
        //工作站的两个操作位之一
        String tagName = request.getParameter("tagName");
        //出库指令ID
        String mesId = request.getParameter("mesId");
        return this.slamTripService.agvTaskFinish(tagName,mesId);
    }*/
    //人工操作完成
    @PostMapping(value = "/agvTaskFinish", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MushinyMessage> agvTaskFinish(@RequestBody String finishTask) {
        Map req = JSONUtil.jsonToMap(finishTask);
        //工作站的两个操作位之一
        String tagName = (String) req.get("tagName");
        //出库指令ID
        String mesId = (String) req.get("mesId");
        //String amount = (String) req.get("amount");
        Integer result=1;
        try
        {
           String res = slamTripService.agvTaskFinish(tagName,mesId);
            logger.info("res:"+res);
        }catch (Exception e)
        {
            result=0;
            logger.error("tagName:"+tagName+" mesId:"+mesId ,e);
            //throw e;
        }

        String message="fail";
        MushinyMessage mm=new MushinyMessage();
        if(result==1) {
            message = "success";
        }
        mm.setCode(result.toString());
        mm.setMessage(message);
        return  ResponseEntity.ok(mm);
    }

    @PostMapping(value = "/emptyPodBack", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<MushinyMessage> emptyPodBack(@RequestBody String podBack) {
        Map req = JSONUtil.jsonToMap(podBack);
        //工作站的两个操作位之一
        String workcenterCode = (String) req.get("WORKCENTER_CODE");
        //出库指令ID
        String mesId = (String) req.get("ID");
        String billType = (String) req.get("BILL_TYPE");
        String invOrgId = (String) req.get("INV_ORG_ID");
        //Integer result=1;
        MushinyMessage mm=new MushinyMessage();
        mm.setDescribe("1成功, 0失败");
        try
        {
            String res = slamTripService.emptyPodBack(workcenterCode,mesId,billType,invOrgId,mm);
            logger.info("res:"+res);
            mm.setMessage(res);
        }catch (Exception e)
        {
            //result=0;
            logger.error("tagName:"+workcenterCode+" mesId:"+mesId ,e);
            //mm.setCode(result);
            mm.setMessage(e.getMessage());
            mm.setCode(0);
        }
        //mm.setCode(result);
        return  ResponseEntity.ok(mm);
    }

    /**
     * 手动调用POD出库，根据指令
     * @param request
     * @param response
     * @return
     */
    @GetMapping(path = "/slamPodOut")
    public String slamPodOut(HttpServletRequest request, HttpServletResponse response) {
        String podId = request.getParameter("podId");
        String mesId = request.getParameter("mesId");
        try {
            String res = slamTripService.slamPodOut(podId, mesId);
            logger.info("res:" + res);
            return res;
        } catch (Exception e) {
            logger.error("podId:" + podId, e);
            return e.getMessage();
        }
    }

    /**
     * 手动调用POD入库，根据指令
     * @param request
     * @param response
     * @return
     */
    @GetMapping(path = "/slamPodIn")
    public String slamPodIn(HttpServletRequest request, HttpServletResponse response) {
        String podId = request.getParameter("podId");
        String mesId = request.getParameter("mesId");
        try {
            String res = slamTripService.slamPodIn(podId,mesId);
            logger.info("res:" + res);
            return res;
        } catch (Exception e) {
            logger.error("podId:" + podId, e);
            return e.getMessage();
        }
    }
}
