package com.mushiny.mq;

/**
 * Created by Tank.li on 2017/6/22.
 */
public interface IReceiver {

    /*主题类型	MQ主题名称
    地图数据请求	RCS_WCS_MAP_REQUEST
    地图数据回复	WCS_RCS_MAP_RESPONSE
    登录数据包	RCS_WCS_ROBOT_LOGIN
    登录数据回复包	WCS_RCS_ROBOT_LOGIN_RESPONSE
    实时数据包	RCS_WCS_ROBOT_RT
    故障数据包	RCS_WCS_ROBOT_ERRORF
    心跳包	RCS_WCS_ROBOT_HEART_BEAT
    周期性状态数据包	RCS_WCS_ROBOT_STATUS

    AGV事件
    AGV连接到RCS	RCS_WCS_ROBOT_CONNECT_RCS
    AGV从RCS断开连接	RCS_WCS_ROBOT_CLOSE_CONNECTION
    AGV状态事件	RCS_WCS_AGV_STATUS
    AGV位置改变	RCS_WCS_AGV_POSITION_CHANGE
    AGV位置不改变超时	RCS_WCS_AGV_NOMOVE_TIMMEOUT
    心跳/实时包未收到超时	RCS_WCS_AGV_HEART_RT_TIMEOUT
    AGV重新连接到RCS并且位置错误	AGV_REPEAT_CONNECT2_RCS_POSITION_ERROR

    路径下发协议
    AGV路径下发	WCS_RCS_AGV_SERIESPATH
    WCS到AGV的动作指令
    停到最近二维码，减速到0	WCS_RCS_AGV_PARKING_NEAREST
    停到最近二维码（回复）	RCS_WCS_AGV_PARKING_RESPONSE
    急停	WCS_RCS_URGENT_STOP
    急停（回复）	RCS_WCS_URGENT_STOP_RESPONSE
    AGV所有电机断电	WCS_RCS_ALL_MOTOR_CUT
    AGV所有电机断电（回复）	RCS_WCS_ALL_MOTOR_CUT_RESPONSE
    开始休眠	WCS_RCS_START_SLEEP
    开始休眠（回复）	RCS_WCS_START_SLEEP_RESPONSE
    结束休眠	WCS_RCS_STOP_SLEEP
    结束休眠（回复）	RCS_WCS_STOP_SLEEP_RESPONSE
    清除已下发路径-清除AGV缓存路径和RCS缓存路径	ON_WCS_RCS_CLEAR_ALLPATH
    清除已下发路径（回复）	RCS_WCS_CLEAR_PATH_RESPONSE
     wms 动态增加pod  WMS_WCS_POD_ADD_REMOVE


    */


    String WMS_WCS_POD_ADD_REMOVE="WMS_WCS_POD_ADD_REMOVE";
    /* 以下是下发的指令 RCS--->WCS */
    String RCS_WCS_MAP_REQUEST = "RCS_WCS_MAP_REQUEST";
    String RCS_WCS_ROBOT_LOGIN = "RCS_WCS_ROBOT_LOGIN";
    String RCS_WCS_SCAN_POD = "RCS_WCS_SCAN_POD";//扫描货位二维码 初始化仓库使用
    String RCS_WCS_POD_ERRORPLACE = "RCS_WCS_POD_ERRORPLACE";//报告错误POD在错误地址
    String RCS_WCS_ROBOT_RT = "RCS_WCS_ROBOT_RT";
    String RCS_WCS_ROBOT_ERROR = "RCS_WCS_ROBOT_ERROR";
    String RCS_WCS_ROBOT_HEART_BEAT = "RCS_WCS_ROBOT_HEART_BEAT";
    String RCS_WCS_ROBOT_STATUS = "RCS_WCS_ROBOT_STATUS";
    String RCS_WCS_ROBOT_CONNECT_RCS = "RCS_WCS_ROBOT_CONNECT_RCS";
    String RCS_WCS_ROBOT_CLOSE_CONNECTION = "RCS_WCS_ROBOT_CLOSE_CONNECTION";
    String RCS_WCS_AGV_STATUS = "RCS_WCS_AGV_STATUS";
    String RCS_WCS_AGV_POSITION_CHANGE = "RCS_WCS_AGV_POSITION_CHANGE";
    String RCS_WCS_AGV_NOMOVE_TIMMEOUT = "RCS_WCS_AGV_NOMOVE_TIMMEOUT";
    String RCS_WCS_AGV_HEART_RT_TIMEOUT = "RCS_WCS_AGV_HEART_RT_TIMEOUT";
    String RCS_WCS_AGV_PARKING_RESPONSE = "RCS_WCS_AGV_PARKING_RESPONSE";
    String RCS_WCS_URGENT_STOP_RESPONSE = "RCS_WCS_URGENT_STOP_RESPONSE";
    String RCS_WCS_ALL_MOTOR_CUT_RESPONSE = "RCS_WCS_ALL_MOTOR_CUT_RESPONSE";
    String RCS_WCS_START_SLEEP_RESPONSE = "RCS_WCS_START_SLEEP_RESPONSE";
    String RCS_WCS_STOP_SLEEP_RESPONSE = "RCS_WCS_STOP_SLEEP_RESPONSE";
    String RCS_WCS_CLEAR_PATH_RESPONSE = "RCS_WCS_CLEAR_PATH_RESPONSE";
    String AGV_REPEAT_CONNECT2_RCS_POSITION_ERROR = "AGV_REPEAT_CONNECT2_RCS_POSITION_ERROR";

    String RCS_WCS_AGV_REQUEST_PATH = "RCS_WCS_AGV_REQUEST_PATH";
    String RCS_WCS_QUERYROBOT_RESPONSE = "RCS_WCS_QUERYROBOT_RESPONSE";
    String MAP_WCS_UPDATE_CELLS = "MAP_WCS_UPDATE_CELLS";
    String MAP_CHARGER_BOARD = "MAP_CHARGER_BOARD";
    String RCS_WCS_LOCK_CELL_TIMEOUT = "RCS_WCS_LOCK_CELL_TIMEOUT";
    String RCS_WCS_UNLOCKED_CELL_LIST = "RCS_WCS_UNLOCKED_CELL_LIST";
    String RCS_WCS_RESPONSE_ITEM_INFO = "RCS_WCS_RESPONSE_ITEM_INFO";
    String RCS_WCS_RESPONSE_MEDIA_AGV_CONFIG_PARAMETERS = "RCS_WCS_RESPONSE_MEDIA_AGV_CONFIG_PARAMETERS";
    String RCS_WCS_RESPONSE_MEDIA_ERROR = "RCS_WCS_RESPONSE_MEDIA_ERROR";
    String RCS_WCS_RESPONSE_ACTION_COMMAND = "RCS_WCS_RESPONSE_ACTION_COMMAND";
    String ANY_WCS_WAREHOUSE_INIT_REQUEST = "ANY_WCS_WAREHOUSE_INIT_REQUEST";
    String RCS_WCS_ACTION_FINISHED_COMMAND = "RCS_WCS_ACTION_FINISHED_COMMAND";
}
