package com.mushiny.controller;

import com.mushiny.beans.Pod;
import com.mushiny.beans.Section;
import com.mushiny.business.PodManager;
import com.mushiny.business.WareHouseManager;
import com.mushiny.mq.MessageSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/7/3.
 */
@RestController
@RequestMapping(value="/midea")
public class MideaController {
    @Autowired
    private PodManager podManager;
    @Autowired
    private WareHouseManager wareHouseManager;

    @Autowired
    private MessageSender messageSender;

    @GetMapping(path = "/allPodsInfo")
    public String checkWorkStationAddrs(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        String sectionId = request.getParameter("sectionId");
        Section section = this.wareHouseManager.getSectionById(sectionId);
        if(section == null){
            section = this.wareHouseManager.getSectionByRcsSectionId(Long.parseLong(sectionId));
        }
        //获取所有信息
        List<Pod> pods = this.podManager.getPods(section);

        return "";
    }

    @GetMapping(path = "/send2Rmq")
    public String send2Rmq(HttpServletRequest request, HttpServletResponse response) {
        /*generalErrorID
        seriousErrorList List
        commonErrorList List
        errorStatus
        sectionID
        time
        robotID
        seriousErrorID
        commonErrorID
        generalErrorList List*/
        /*response.setHeader("Access-Control-Allow-Origin", "*");
        Map data = new HashMap();
        data.put("robotID",1L);
        data.put("time",System.currentTimeMillis());
        data.put("generalErrorID",1);
        List generalErrorList = new ArrayList();
        Map detail = new HashMap();
        detail.put("description","不在Tag位");
        detail.put("generalErrorID",1);
        detail.put("bitPosition",2);
        generalErrorList.add(detail);
        data.put("generalErrorList",generalErrorList);
        data.put("seriousErrorID",1);
        data.put("commonErrorID",1);
        data.put("errorStatus","errorStatus");*/

        Map data = new HashMap();
        /*请求名称	String	 name
         sectionID	Long	 sectionID
         时间戳	    Long	 requestTime*/
        data.put("sectionID",1L);
        data.put("requestTime",System.currentTimeMillis());

        this.messageSender.sendMsg("section1","RCS_WCS_MAP_REQUEST",data);

        return "OK";
    }

}
