package com.mushiny.beans.order.midea;

import com.mushiny.beans.Address;
import com.mushiny.beans.Robot;
import com.mushiny.beans.Section;
import com.mushiny.beans.enums.AddressStatus;
import com.mushiny.beans.enums.AddressType;
import com.mushiny.beans.enums.TripStatus;
import com.mushiny.beans.order.Order;
import com.mushiny.comm.CommonUtils;
import com.mushiny.comm.JsonUtils;
import com.mushiny.mq.ISender;
import com.mushiny.mq.MessageSender;
import org.apache.http.client.utils.DateUtils;

import java.util.*;

/**
 * Created by Tank.li on 2017/9/5.
 */
public class PodRunOrder extends Order {

    //private Long endAddr;
    private String type = "PodRun";

    private String instructId;

    public String getInstructId() {
        return instructId;
    }

    public void setInstructId(String instructId) {
        this.instructId = instructId;
    }

    @Override
    public void sendMessage2Rcs() {
        Map message = this.genWcsMessage();
        MessageSender.sendMapMessage(message, ISender.WCS_RCS_AGV_SERIESPATH);
        this.setMessage(JsonUtils.map2Json(message));
        this.setSend2RcsTime(DateUtils.formatDate(new Date(System.currentTimeMillis())));
    }

    //南沙两种情况
    // 一种是随机分配 目标地址为0或者为空
    //一种是指定目标地址
    @Override
    public void initOrder() {
        if (this.getPod().getLockedBy() != 0L
                && this.getPod().getLockedBy() != this.getRobot().getRobotId()) {//未被释放
            this.setOrderError(Order.ERROR_POD);
            return;
        }

        if (this.getPod().getAddress() == null) {
            this.setOrderError(Order.ERROR_POD_NOTINMAP);
            return;
        }

        boolean locked = this.getPod().lockPod(this);
        if (!locked) {
            logger.error("调度单锁定POD失败! RobotId:" + this.getRobot().getRobotId()
                    + "未锁定pod:" + this.getPod().getPodName() + " 已 locked by: " + this.getPod().getLockedBy());
            this.setOrderError(Order.ERROR_POD);
            return;
        }
        this.wcsPath.setEndAddr(this.getEndAddr());
        Long srcAddr = Long.parseLong(getRobot().getAddressId());
        this.wcsPath.setSrcAddr(srcAddr);
        //第一阶段任务 空车
        Integer sourceVertex = CommonUtils.long2Int(srcAddr);
        Integer targetVertex = Integer.parseInt(this.getPod().getAddress().getId());

        List<Long> path = this.getWebApiBusiness().getEmptyPath(this.getWareHouseId(), getSectionId(), sourceVertex, targetVertex);
        if (path == null || path.size() == 0) {
            this.setOrderError(Order.ERROR_EMPTY_PATH);
            return;
        }

        //恢复原先锁定的节点 设置新的目标地址 20190411
        Long preLocked = this.getEndAddr();//this.getRobot().getLockedAddr();
        Long preLocked2 = this.getRobot().getLockedAddr();

        //第二阶段任务 重车
        if (!this.lockEndAddr()) {
            logger.debug("PodRun没有定义目标地址或无法锁定该目标地址,通过热度算法生成");
            //这三种类型不需要重新计算
            if (!MideaConstants.CarryPod.equalsIgnoreCase(this.type)
                    && !MideaConstants.ANNTOMVOUT.equalsIgnoreCase(this.type)
                    && !MideaConstants.LMGETMATERIAL.equalsIgnoreCase(this.type)) {
                boolean success = this.getPodManager().targetAndLock(this.getPod(), this.getRobot(),this.getRobotManager());
                if (!success) {
                    logger.error(this.getOrderId() + "的POD=" + this.getPod().getPodName() + ":热度算法没有生成目标地址");
                    //从地图上查找一次
                    Section section = this.getWareHouseManager().getSectionById(this.getSectionId());
                    List<Address> addresses = section.getStorageAddrs();
                    for (int i = 0; i < addresses.size(); i++) {
                        Address address = addresses.get(i);
                        if(address.getType() == AddressType.STORAGE && noPodOnAddress(address)){
                            //success = address.robotLock(this.getRobot().getRobotId(),true);
                            //如果该节点被某小车锁定，而小车锁定的目的地不是该节点，表示数据有问题 2020-01-20
                            Robot lockedRobot = this.getRobotManager().getRobotById(address.getLockedBy());
                            //@2020-04-11 判断空
                            if(lockedRobot == null || lockedRobot.getLockedAddr() != Long.parseLong(address.getId())){
                                logger.error("没有锁定的小车 或 该位置锁定的小车目的地不是这个点 lockedRobot.getLockedAddr():"
                                        +lockedRobot+" address.getId():"+address.getId());
                                //2020-04-12 可以使用的地址
                                logger.error(this.getOrderId() + "的POD="
                                        + this.getPod().getPodName()+" 获取到目标地址:"+address.getId());
                                this.getRobot().setLockedAddr(Long.parseLong(address.getId()));
                                address.setLockedBy(this.getRobot().getRobotId());
                                address.setNodeState(AddressStatus.RESERVED);
                                break;
                            }
                        }
                        //logger.debug("Address 不合适 :");
                    }
                    //还是没找到....
                    if (!success) {
                        this.setOrderError(Order.ERROR_NO_HOTADDRESS);
                        return;
                    }else{
                        logger.error("通过新方法生成了目的地址:"+this.getRobot().getLockedAddr());
                    }
                }
                setEndAddr(this.getRobot().getLockedAddr());

            } else {
                logger.error(this.getOrderId() + "的POD=" + this.getPod().getPodName() + "目标地址" + this.getEndAddr() + " 锁定失败!");
                this.setOrderError(Order.ERROR_LOCK_ENDADDR);
                return;
            }
        }

        logger.error("调度单:" + this.getOrderId() + "定义的目标节点是:" + this.getEndAddr());
        //如果运算出来的节点不一样 需要恢复原先节点
        if (preLocked != 0L && !Objects.equals(preLocked, this.getEndAddr())) {
            logger.info("调度单" + this.getRobot().getRobotId() + "的原目标地址:"
                    + preLocked + " 新目标地址:" + this.getEndAddr() + "不相同!");
            Address preLockedAddr = this.getWareHouseManager()
                    .getAddressByAddressCodeId(preLocked, this.getSectionId());
            if (preLockedAddr != null) {
                preLockedAddr.robotLock(this.getRobot().getRobotId(), false);
            }
            logger.error("调度单 " + this.getOrderId() + " 原先锁定的地址" + preLockedAddr + "已恢复");
        }

        logger.error("小车:" + this.getOrderId() + "锁定的目标节点是:" + this.getRobot().getLockedAddr());
        //如果运算出来的节点不一样 需要恢复原先节点
        if (preLocked2 != 0L && !Objects.equals(preLocked2, this.getRobot().getLockedAddr())) {
            logger.info("小车" + this.getRobot().getRobotId() + "的原目标地址:"
                    + preLocked2 + " 新目标地址:" + this.getRobot().getLockedAddr() + "不相同!");
            Address preLocked2Addr = this.getWareHouseManager()
                    .getAddressByAddressCodeId(preLocked2, this.getSectionId());
            if (preLocked2Addr != null) {
                preLocked2Addr.robotLock(this.getRobot().getRobotId(), false);
            }
            logger.error("小车 " + this.getOrderId() + " 原先锁定的地址" + preLocked2Addr + "已恢复");
        }


        //结束设置小车新的目标地址
        this.wcsPath.setEndAddr(this.getEndAddr());

        Integer dest = CommonUtils.long2Int(this.getEndAddr());
        List<Long> path2 = this.getWebApiBusiness().getHeavyPath(this.getWareHouseId(), getSectionId(), targetVertex, dest);
        if (path2 == null || path2.size() == 0) {
            this.setOrderError(Order.ERROR_HEAVY_PATH);
            logger.error(this.getOrderId() + " 重车路径计算失败已恢复目标地址:" + this.getEndAddr());
            Address tarAddr = this.getWareHouseManager().getAddressByAddressCodeId(this.getEndAddr(), this.getSectionId());
            if (tarAddr != null) {
                tarAddr.robotLock(this.getRobot().getRobotId(), false);
            }
            return;
        }

        this.add2Path(path, path2);
        //this.setEndAddr();
        wcsPath.setPodUpAddress(Long.parseLong(this.getPod().getAddress().getId()));
        wcsPath.setPodDownAddress(this.getEndAddr());
        this.wcsPath.setSeriesPath(path);
    }
    public static final String SQL_NOPOD_ON_ADDRESS = "SELECT 1 FROM MD_POD WHERE PLACEMARK=? AND SECTION_ID=?";
    private boolean noPodOnAddress(Address address) {
        List list = this.getJdbcRepository().queryBySql(SQL_NOPOD_ON_ADDRESS,
                Integer.parseInt(address.getId()),address.getSectionId());
        return list==null || list.isEmpty();
    }


    @Override
    public void process() {
        this.addKV("TRIP_STATE", TripStatus.PROCESS);
        this.getJdbcRepository().updateBusinessObject(this);
        //更新POD和目标地址信息
        updatePodTarget();
        //如果POD属于深层货架里头，将同组外面的节点Reserved掉
        updatePodOutterAddr();

    }

    public void onPodUpMove(){
        logger.debug("货架"+this.getPod().getPodName()+"离开举升位置!");
        Map message = new LinkedHashMap();
        Section section = this.getWareHouseManager().getSectionById(this.getRobot().getSectionId());
        message.put("sectionID",section.getRcs_sectionId());
        message.put(MideaConstants.TRIP_ID,this.getOrderId());
        message.put(MideaConstants.TRIP_TYPE,this.getType());
        message.put(MideaConstants.POD_INDEX,this.getPod().getPodId());
        message.put(MideaConstants.SOURCE_ADDRESS, this.getWcsPath().getPodUpAddress());
        message.put(MideaConstants.TARGET_ADDRESS, this.getEndAddr());
        message.put(MideaConstants.DRIVE_ID, this.getRobot().getRobotId());
        message.put(MideaConstants.POD_INDEX,this.getPod().getPodId());
        message.put(MideaConstants.INSTRUCT_STATUS, MideaConstants.RUNNING);
        message.put(MideaConstants.INSTRUCT, this.getInstructId());
        MessageSender.sendMapMessage(message, MideaConstants.INSTRUCTACK);
    }

    public void onPodDownStop(){
        //finish
    }

    @Override
    public void finish() {
        this.addKV("TRIP_STATE", TripStatus.FINISHED);
        this.getJdbcRepository().updateBusinessObject(this);
        if (this.getPod() != null) {
            this.getPodManager().finishMainOrder(this);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        Long addr = this.getEndAddr();
        if (addr == 0L) {
            this.setOrderError(Order.ERROR_NO_HOTADDRESS);
            return;
        }
        Address address = this.getWareHouseManager().getAddressByAddressCodeId(addr, this.getSectionId());
        logger.debug("返回存储区调度单出错:Order:" + this.getOrderId() + " 目标节点恢复:" + addr);
        if (address != null) {
            address.robotLock(this.getRobot().getRobotId(), false);
        }
        this.getRobot().setAvaliable(true);
    }

    @Override
    public boolean isFinish() {
        Long orderEnd = this.getWcsPath().getEndAddr();
        logger.debug(this.getOrderId() + "this.getPod():" + this.getPod());
        logger.debug(this.getOrderId() + "orderEnd:" + orderEnd);
        logger.debug(this.getOrderId() + "endAddr:" + this.getEndAddr());
        if ((Objects.equals(Long.parseLong(this.getPod().getAddress().getId()), this.getEndAddr())
                || Objects.equals(orderEnd, Long.parseLong(this.getPod().getAddress().getId())))
                /*&& Objects.equals(this.getRobot().getPod(), this.getPod())*/) {//必须托起POD
            this.setCanFinish(true);
            return true;
        }
        return false;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;

    }

    @Override
    public void reInitOrder() {
        this.initOrder();//同一样处理
    }

    @Override
    public String toString() {
        return "PodRunOrder{" +
                "msg=" + this.getMessage() +
                "sendTime=" + this.getSend2RcsTime() +
                "target=" + this.getEndAddr() +
                "pod=" + this.getPod() +
                ", getWcsPath=" + this.getWcsPath() +
                ", orderId=" + this.getOrderId() +
                ", type=" + this.getType() +
                '}';
    }
}
