package com.mushiny.mq;

import com.mushiny.business.RobotManager;
import com.mushiny.business.WebApiBusiness;
import com.mushiny.comm.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.*;

/**
 * Created by Administrator on 2018/10/15.
 */
@Component
public class MideaSlamListener {
    private final static Logger logger = LoggerFactory.getLogger(WebApiBusiness.class);

    public static final String WCS_SLAM_InstructAck = "WCS_SLAM_InstructAck";
    @Value("${mushiny.midea.slam.url}")
    private String mideaUrl;

    @Value("${mushiny.midea.slam.appSecret}")
    private String appSecret;

    private final RestTemplateBuilder builder;

    @Autowired
    public MideaSlamListener(RestTemplateBuilder builder) {
        this.builder = builder;
    }

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "section1" , ignoreDeclarationExceptions = "true"),
            key = WCS_SLAM_InstructAck))
    public void WCS_SLAM_InstructAck(Message message) {
        byte[] body = message.getBody();
        Map data = (Map) CommonUtils.toObject(body);
        if(data==null || data.isEmpty()){
            return;
        }
        //处理逻辑
        RestTemplate restTemplate = builder.build();

        /*{
            "taskId": "任务标识，string (20)，必填 任务更新操作的主键",
            "areaCode": "区域编码，string (50)，选填 ",
            "warehouseCode": "仓库编码，string (50)，选填 例如：南沙空调 4#厂房",
            "taskType": "任务类型，int，必填 0-运送物料 1-空料架回收 2-任务异常处理",
            "startTag": "任务起点，string (50)，选填 ",
            "endTag": "任务终点，string (50) ，必填",
            "storageNo": "料架编码，string (50) ，选填 默认”0” ",
            "priority": "优先级，int，选填，默认 99 0-优先级最高"
            "taskDateTime": "交互当前时间，string（23）， ‘yyyy-MM-DD HH:mm:ss.fff’ "
        }*/

        Map params = new HashMap();
        params.put("storageNo",CommonUtils.parseString("",data));

        String sign = this.exportSign(params);

        String res = restTemplate.getForObject(this.mideaUrl,      String.class);

    }

    private String exportSign(Map params) {
        List keys = new ArrayList();
        keys.addAll(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.appSecret);
        for (int i = 0; i < keys.size(); i++) {
            String key = (String) keys.get(i);
            stringBuilder.append(key).append(CommonUtils.parseString(key,params));
        }
        stringBuilder.append(this.appSecret);

        logger.debug("拼接后的字符串是:"+stringBuilder);
        String md5Str = CommonUtils.md5(stringBuilder.toString());
        logger.debug("MD5的字符串是:"+stringBuilder);
        return md5Str;
    }
}
