package com.mushiny.mq;

import com.mushiny.business.WebApiBusiness;
import com.mushiny.comm.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * 监听需要发送RFID指令的
 * 一种是出库到达
 * 一种是入库离开
 */
@Component
public class MideaRFIDListener {
    private final static Logger logger = LoggerFactory.getLogger(MideaRFIDListener.class);
    private static final String ANNTOMVOUT = "ANNTOMVOUT";
    private static final String LMGETMATERIAL = "LMGETMATERIAL";

    @Value("${mushiny.midea.rfid.url}")
    private String mideaUrl;

    private final RestTemplateBuilder builder;

    @Autowired
    public MideaRFIDListener(RestTemplateBuilder builder) {
        this.builder = builder;
    }

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "section1" , ignoreDeclarationExceptions = "true"),
            key = ANNTOMVOUT))
    public void ANNTOMVOUT(Message message) {
        byte[] body = message.getBody();
        Map data = (Map) CommonUtils.toObject(body);
        this.onArriveStopPoint(data);
        logger.info("到达出口处理完毕!"+data);
    }

    @RabbitListener(bindings = @QueueBinding(
            value = @Queue(value = "", durable = "true"),
            exchange = @Exchange(value = "section1" , ignoreDeclarationExceptions = "true"),
            key = LMGETMATERIAL))
    public void LMGETMATERIAL(Message message) {
        byte[] body = message.getBody();
        Map data = (Map) CommonUtils.toObject(body);
        this.onArriveStopPoint(data);
        logger.info("到达出口处理完毕!"+data);
    }

    private void onArriveStopPoint(Map data){

    }

    private void OnLeaveStopPoint(Map data){

    }
}
