package com.mushiny.metage.api;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Map;

/**
 * @version 1.0
 * @author： Gy
 * @date： 2023-02-31 13:53
 */
@RestController
@CrossOrigin(origins = "*", maxAge = 3600)
@RequestMapping("/mushiny")
public class MetageController {

    @RequestMapping("/getWeight")
    public void getWeight(@RequestBody(required = false) Map<String, String> map) throws Exception{
        /*cRead.outputStream.write(st.getBytes("gbk"), 0, st.getBytes("gbk").length);*/
        /*return RxtxUtils.weightings;*/
        //服务端获取客户端发送数据
        receiveData();
    }

    private void receiveData() throws IOException{
        //于服务端而言，首先需要定义DatagramSocket对象，指定接受端口。
        DatagramSocket server = new DatagramSocket(10086);

        //定义接受数据的packet包，这算是一个存储接收的容器
        byte[] bytes = new byte[1024];
        DatagramPacket packet = new DatagramPacket(bytes,bytes.length);

        //用定义的pakcet接受客户端传送过来的数据
        server.receive(packet);

        //接收完成之后，数据在容器里面，需要调用容器的getData()方法获取之前定义好的数据类型的数据
        //比如说之前定义packet接收包的时候，定义的是字节数据，所以获取的也是字节数组。
        byte[] receiveData = packet.getData();
        //拿到数据之后，我们可以把它转化为字符串输出打印到控制台上。
        String receiveString = new String(receiveData,0,receiveData.length);

        System.out.println(receiveString);

        //关闭资源
        server.close();
    }

}
