package com.mushiny.metage.util;

import com.mushiny.metage.webSocket.WebSocket;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.*;
import java.net.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import gnu.io.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import static com.mushiny.metage.util.HexadecimalUtil.hexStringToByteArray;

/**
 * @version 1.0
 * @author： Gy
 * @date： 2023-02-31 13:54
 */
public class RxtxUtils extends Thread implements SerialPortEventListener {

    // 监听器,我的理解是独立开辟一个线程监听串口数据
    static CommPortIdentifier portId; // 串口通信管理类
    static Enumeration<?> portList; // 有效连接上的端口的枚举
    InputStream inputStream; // 从串口来的输入流
    public static OutputStream outputStream;// 向串口输出的流
    static SerialPort serialPort; // 串口的引用
    // 堵塞队列用来存放读到的数据
    private BlockingQueue<String> msgQueue = new LinkedBlockingQueue<String>();
    //当前接收到的重量信息
    public static Double weightings;
    /**
     * SerialPort EventListene 的方法,持续监听端口上是否有数据流
     */
    @Override
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case SerialPortEvent.BI:
            case SerialPortEvent.OE:
            case SerialPortEvent.FE:
            case SerialPortEvent.PE:
            case SerialPortEvent.CD:
            case SerialPortEvent.CTS:
            case SerialPortEvent.DSR:
            case SerialPortEvent.RI:
            case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
                break;
            case SerialPortEvent.DATA_AVAILABLE:// 当有可用数据时读取数据
                byte[] readBuffer = new byte[1024];
                try {
                    int numBytes = -1;
                    while (inputStream.available() > 0) {
                        numBytes = inputStream.read(readBuffer);

                        if (numBytes > 0) {
                            msgQueue.add(new String(readBuffer,"gbk"));
                            readBuffer = new byte[1024];// 重新构造缓冲对象，否则有可能会影响接下来接收的数据
                        } else {
                            msgQueue.add("!------No data read");
                        }
                    }
                } catch (IOException e) {
                }
                break;
        }
    } // SerialPortEventListener {


    /**
     *
     * 通过程序打开COM4串口，设置监听器以及相关的参数
     *
     * @return 返回1 表示端口打开成功，返回 0表示端口打开失败
     */
    public int startComPort(String portName,int bitRate,int dataBits,int stopBit,int parityBit) {
        // 通过串口通信管理类获得当前连接上的串口列表
        portList = CommPortIdentifier.getPortIdentifiers();

        while (portList.hasMoreElements()) {
            // 获取相应串口对象
            portId = (CommPortIdentifier) portList.nextElement();

            System.out.println("Equipment type：--->" + portId.getPortType());
            System.out.println("Device Name：---->" + portId.getName());
            // 判断端口类型是否为串口
            if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                // 判断如果COM7串口存在，就打开该串口
                if (portId.getName().equals(portName)) {
                    try {
                        // 打开串口名字为COM_7(名字任意),延迟为2毫秒
                        serialPort = (SerialPort) portId.open(portName, 2000);

                    } catch (PortInUseException e) {
                        e.printStackTrace();
                        return 0;
                    }
                    // 设置当前串口的输入输出流
                    try {
                        inputStream = serialPort.getInputStream();
                        outputStream = serialPort.getOutputStream();
                    } catch (IOException e) {
                        e.printStackTrace();
                        return 0;
                    }
                    // 给当前串口添加一个监听器
                    try {
                        serialPort.addEventListener(this);
                    } catch (TooManyListenersException e) {
                        e.printStackTrace();
                        return 0;
                    }
                    // 设置监听器生效，即：当有数据时通知
                    serialPort.notifyOnDataAvailable(true);

                    // 设置串口的一些读写参数
                    try {
                        // 比特率、数据位、停止位、奇偶校验位
                        serialPort.setSerialPortParams(bitRate,
                                dataBits, stopBit,
                                parityBit);
                    } catch (UnsupportedCommOperationException e) {
                        e.printStackTrace();
                        return 0;
                    }

                    return 1;
                }
            }
        }
        return 0;
    }

    //处理返回后的消息
    @Override
    public void run() {
        try {
            while (true) {
                // 如果堵塞队列中存在数据就将其输出
                if (msgQueue.size() > 0) {
                    weightings = Double.parseDouble(msgQueue.take());
                    System.out.println("Received messages："+weightings);
                    WebSocket webSocket = new WebSocket();
                    webSocket.sendAllToUserMessage(String.valueOf(weightings));
//                    sendDate(weightings);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendToPort(String data) {
        OutputStream out = null;
        try {
            out = serialPort.getOutputStream();
            out.write(data.getBytes());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void sendDate(Double weightings) throws IOException{
        //客户端发送数据，首先用无参构造方法获得DatagramSocket对象。
        DatagramSocket send = new DatagramSocket();

        //首先需要明确发送的数据类型和格式，比如字节数组
        byte[] sendData = weightings.toString().getBytes();

        //我们创建DatagramPacket打包对象对其进行打包
        //四个参数分别为：数据，数据长度，主机地址，端口
        DatagramPacket dataPacket = new DatagramPacket(
                sendData,sendData.length, InetAddress.getByName("192.128.2.208"),10086);

        //调用DatagramSocket对象的send()方法进行数据发送
        send.send(dataPacket);

        //关闭资源
        send.close();
    }

}
