package com.mushiny.metage.webSocket;

import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.ServerEndpoint;
import java.util.concurrent.CopyOnWriteArraySet;

@ServerEndpoint(value = "/websocket")
@Component
public class WebSocket {

    private static CopyOnWriteArraySet<WebSocket> webSocketSet = new CopyOnWriteArraySet<WebSocket>();

    //与某个客户端的连接回话，需要通过它来给客户端发送数据
    private Session session;

    @OnOpen
    public void onOpen(Session session){

        this.session = session;
        //加入set中
        webSocketSet.add(this);
        System.out.println("Establishing a connection："+webSocketSet.size());
    }

    //给所有当前连接的用户发送消息
    public void sendAllToUserMessage(String message){
        try {
            if(webSocketSet.size() != 0){
                for (WebSocket item:
                     webSocketSet) {
                    item.session.getBasicRemote().sendText(message);
                    System.out.println("Messages sent by the server："+message);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    //当浏览器关闭触发该事件
    @OnClose
    public void onClose(Session session){
        webSocketSet.remove(this);
        System.out.println("Establishing a connection："+webSocketSet.size());
    }

    //接收前端发送的消息
    @OnMessage
    public void onMessage(String params,Session session){
        //params就是发送的消息根据自己的业务进行操作就可以了
        System.out.println(params);
    }

    //发送错误时调用
    @OnError
    public void onError(Session session,Throwable error){
        System.out.println("webSocket Sending error！！！");
        error.printStackTrace();
    }

}
