package com.mushiny.wms.mfg.interceptor;

import cn.hutool.core.util.IdUtil;
import com.mushiny.wms.mfg.constant.DateFormatPattern;
import com.mushiny.wms.mfg.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.modules.db.inteceptor.NamedTableInterceptor;
import org.ssssssss.magicapi.modules.db.model.SqlMode;
import org.ssssssss.magicapi.modules.db.table.NamedTable;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 拦截请求(字段自动填充)
 *
 * @author Gy
 * @since 4.0.0
 */
@Component
public class MyNamedTableInterceptor implements NamedTableInterceptor {

    @Value("${mushiny.user}")
    private Long userId;

    @Override
    public void preHandle(SqlMode sqlMode, NamedTable namedTable) {

        if (sqlMode == SqlMode.INSERT) {
            namedTable.column("id", IdUtil.getSnowflakeNextId());
            namedTable.column("creator", userId);
            namedTable.column("create_date", new Date());
            namedTable.column("updater", userId);
            namedTable.column("update_date", new Date());
        }else if (sqlMode == SqlMode.UPDATE) {
            namedTable.column("updater", userId);
            namedTable.column("update_date", new Date());
        }
    }

}
