{
  "properties" : { },
  "id" : "ef0747f27ea94b5e8a948aa14ef1a56e",
  "script" : null,
  "groupId" : "504dbc7823444f7a8df13edb6b189120",
  "name" : "创建商品",
  "createTime" : null,
  "updateTime" : 1677140562317,
  "lock" : null,
  "createBy" : null,
  "updateBy" : "admin",
  "path" : "product",
  "method" : "POST",
  "parameters" : [ ],
  "options" : [ ],
  "requestBody" : "{\n\t\"client_no\": \"C-MELB TTC\",\n\t\"external_sku_id\": \"G2023012901\",\n\t\"sku_no\": [\"G2023012901\"],\n\t\"name\": \"G测试商品2\",\n\t\"description\": \"This is a T - shirt\",\n\t\"product_group\": \"Normal\",\n\t\"brand\": \"Midas\",\n\t\"exp_date_mandatory_flag\": \"N\",\n\t\"serial_record_flag\": \"N\",\n\t\"measure_flag\": \"N\",\n\t\"weight\": 40,\n\t\"width\": 20,\n\t\"length\": 20,\n\t\"height\": 10,\n\t\"picture_resource_name\": \"https: //www.baidu.com/pic/demo/test.jpg\",\n\t\"batch\": \"N\"\n}",
  "headers" : [ ],
  "paths" : [ ],
  "responseBody" : "{\n    \"status\": \"ERROR\",\n    \"message\": \"Client does not exist\",\n    \"datetime\": \"23-02-2023 19:22:34\",\n    \"client_no\": \"C-MELB TTC1\",\n    \"external_sku_id\": \"G2023012901\"\n}",
  "description" : null,
  "requestBodyDefinition" : {
    "name" : "",
    "value" : "",
    "description" : "",
    "required" : false,
    "dataType" : "Object",
    "type" : null,
    "defaultValue" : null,
    "validateType" : "",
    "error" : "",
    "expression" : "",
    "children" : [ {
      "name" : "client_no",
      "value" : "C-MELB TTC",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "external_sku_id",
      "value" : "G2023012901",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "sku_no",
      "value" : "",
      "description" : "",
      "required" : false,
      "dataType" : "Array",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ {
        "name" : "",
        "value" : "G2023012901",
        "description" : "",
        "required" : false,
        "dataType" : "String",
        "type" : null,
        "defaultValue" : null,
        "validateType" : "",
        "error" : "",
        "expression" : "",
        "children" : [ ]
      } ]
    }, {
      "name" : "name",
      "value" : "G测试商品2",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "description",
      "value" : "This is a T - shirt",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "product_group",
      "value" : "Normal",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "brand",
      "value" : "Midas",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "exp_date_mandatory_flag",
      "value" : "N",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "serial_record_flag",
      "value" : "N",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "measure_flag",
      "value" : "N",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "weight",
      "value" : "40",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "width",
      "value" : "20",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "length",
      "value" : "20",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "height",
      "value" : "10",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "picture_resource_name",
      "value" : "https: //www.baidu.com/pic/demo/test.jpg",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "batch",
      "value" : "N",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    } ]
  },
  "responseBodyDefinition" : {
    "name" : "",
    "value" : "",
    "description" : "",
    "required" : false,
    "dataType" : "Object",
    "type" : null,
    "defaultValue" : null,
    "validateType" : "",
    "error" : "",
    "expression" : "",
    "children" : [ {
      "name" : "status",
      "value" : "ERROR",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "message",
      "value" : "Client does not exist",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "datetime",
      "value" : "23-02-2023 19:22:34",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "client_no",
      "value" : "C-MELB TTC1",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "external_sku_id",
      "value" : "G2023012901",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    } ]
  }
}
================================
import response;
import env;
import 'com.mushiny.wms.mfg.dto.ProductResult' as ProductResult;
import 'com.mushiny.wms.mfg.constant.ResultStatus' as ResultStatus;
import 'com.mushiny.wms.mfg.entity.ProductGroup' as ProductGroup;
import 'com.mushiny.wms.mfg.entity.Uom' as Uom;
import 'com.mushiny.wms.mfg.entity.ProductType' as ProductType;
import 'com.mushiny.wms.mfg.entity.ProductBrand' as ProductBrand;
import 'com.mushiny.wms.mfg.entity.Product' as Product;
import 'com.mushiny.wms.mfg.entity.ProductCode' as ProductCode;
import 'cn.hutool.core.bean.BeanUtil' as BeanUtil;
import 'java.math.BigDecimal' as BigDecimal;
import 'com.mushiny.wms.mfg.constant.ProductConstant' as ProductConstant;


var warehouseId = env.get('mushiny.warehouse')::long;

var saveProductCode = (productId, dto, client) => {
    for (val in dto.sku_no) {
        ProductCode productCode = new ProductCode();
        productCode.setCode(val);
        productCode.setProductId(productId);
        productCode.setClientId(client.id);
        productCode.setWarehouseId(warehouseId);
        db.table('md_product_code').insert(BeanUtil.beanToMap(productCode))
    }
}

var save = (product, body, productGroup, uom, productType, productBrand, client, createFlag) => {
    product.setCode(body.external_sku_id);
    product.setSku(body.sku_no[0]);
    product.setName(body.name);
    product.setProductGroupId(productGroup.id);
    product.setBrandId(productBrand.id);
    product.setUomId(uom.id);
    product.setProductTypeId(productType.id);
    product.setDescription(body.description);
    //单位米
    product.setDepth(is_null(body.length) || new BigDecimal(body.length).compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.001") : new BigDecimal(body.length).divide(new BigDecimal(1000)).setScale(3, BigDecimal.ROUND_HALF_UP));
    product.setWidth(is_null(body.width) || new BigDecimal(body.width).compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.001") : new BigDecimal(body.width).divide(new BigDecimal(1000)).setScale(3, BigDecimal.ROUND_HALF_UP));
    product.setHeight(is_null(body.height) || new BigDecimal(body.height).compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.001") : new BigDecimal(body.height).divide(new BigDecimal(1000)).setScale(3, BigDecimal.ROUND_HALF_UP));
    product.setVolume(product.getDepth().multiply(product.getWidth()).multiply(product.getHeight()).setScale(6, BigDecimal.ROUND_HALF_UP));
    //单位千克
    product.setWeight(is_null(body.weight) || new BigDecimal(body.weight).compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.001") : new BigDecimal(body.weight).divide(new BigDecimal(1000)).setScale(3, BigDecimal.ROUND_HALF_UP));
    if (ProductConstant.Y.equalsIgnoreCase(body.exp_date_mandatory_flag)) {
        product.setBestBeforeMandatory(1);
        if (ProductConstant.EXP.equalsIgnoreCase(body.exp_date_type)) {
            product.setBestBeforeType("EXP");
        } else {
            product.setBestBeforeType("PRD");
            product.setBestBeforeUnit(is_blank(body.getExp_unit())?"DAY" : body.exp_unit.toUpperCase());
        }
    } else {
        product.setBestBeforeMandatory(0);
    }
    if(not_blank(body.serial_record_flag) && ("Y").equals(body.serial_record_flag)){
        product.setSerialNoRecordType(1);
    } else {
        product.setSerialNoRecordType(0);
    }
    if (not_blank(body.exp_threshold)) {
        product.setRestUsageGi(body.getExp_threshold()::int);
    } else {
        product.setRestUsageGi(0);
    }
    product.setRestUsageGo(0);
    product.setPictureUrl(body.picture_resource_name);
    product.setAdviceMandatory(0);
    product.setLotMandatory(0);
    product.setLotSubstitutionType(0);
    product.setWeightRecordType(0);
    product.setShelfLife(0);
    product.setSafetyStock(0);
    product.setWarehouseId(warehouseId);
    product.setClientId(client.id);
    if (createFlag) {
        var productId = db.table('md_product').insert(BeanUtil.beanToMap(product))
        saveProductCode(productId,body,client);
    } else {
        db.table('md_product').primary('id').update(BeanUtil.beanToMap(product))
        var productCodeList = db.select('select * from md_product_code where product_id = #{product.id}'); 
        for (val in productCodeList) {
            db.table('md_product_code').primary('id').update({id : val.id, del_flag : 1})
        }
        saveProductCode(product.id,body,client);
    }
}

ProductResult productResult = new ProductResult();
productResult.setClient_no(body.client_no).setExternal_sku_id(body.external_sku_id);

//商品分组
var productGroup = db.selectOne('select * from md_product_group where code = #{body.product_group} and warehouse_id = #{warehouseId}'); 
if (is_null(productGroup)) {
    productGroup = new ProductGroup();
    productGroup.setCode(body.product_group);
    productGroup.setName(body.product_group);
    productGroup.setWarehouseId(warehouseId);
    db.table('md_product_group').insert(BeanUtil.beanToMap(productGroup))
}
//商品单位
var uomCode = 'Pieces';
var uom = db.selectOne('select * from md_uom where code = #{uomCode} and warehouse_id = #{warehouseId}'); 
if (is_null(uom)) {
    uom = new Uom();
    uom.setCode(uomCode);
    uom.setName(uomCode);
    uom.setUnitType('PIECE');
    uom.setWarehouseId(warehouseId);
    db.table('md_uom').insert(BeanUtil.beanToMap(uom))
}
//商品类型
var typeCode = 'default';
var productType = db.selectOne('select * from md_product_type where code = #{typeCode} and warehouse_id = #{warehouseId}'); 
if (is_null(productType)) {
    productType = new ProductType();
    productType.setCode(typeCode);
    productType.setName(typeCode);
    productType.setWarehouseId(warehouseId);
    db.table('md_product_type').insert(BeanUtil.beanToMap(productType))
}
//商品品牌
ProductBrand productBrand = new ProductBrand();
if(not_blank(body.brand)){
    productBrand = db.selectOne('select * from md_brand where code = #{body.brand}'); 
    if(is_null(productBrand)){
        productBrand = new ProductBrand();
        productBrand.setCode(body.brand);
        productBrand.setName(body.brand);
        db.table('md_brand').insert(BeanUtil.beanToMap(productBrand))
    }
}
//货主
var client = db.selectOne("select * from sys_client where code = #{body.client_no} "); 
if(is_null(client)){
    return response.json(productResult.setStatus(ResultStatus.error).setMessage('Client does not exist'));
}

var product = db.selectOne('select * from md_product where code = #{body.external_sku_id} and warehouse_id = #{warehouseId} and client_id = #{client.id}'); 
if(is_null(product)){
    //判断多条码商品
    for (val in body.sku_no) {
        var p = db.selectOne('select * from md_product_code where code = #{val} and client_id = #{client.id}'); 
        if (not_null(p)) {
            return response.json(productResult.setStatus(ResultStatus.error).setMessage('sku_no already exists'));
        }
    }
    save(new Product(), body, productGroup, uom, productType, productBrand, client, true);
} else {
    for (val in body.sku_no) {
        var p = db.selectOne('select * from md_product_code where code = #{val} and client_id = #{client.id}'); 
        if (not_null(p)) {
            if(!p.productId.equals(product.id)){
                return response.json(productResult.setStatus(ResultStatus.error).setMessage('sku_no already exists'));
            }
        }
    }
    product = BeanUtil.fillBeanWithMap(product, new Product(), false);
    save(product, body, productGroup, uom, productType, productBrand, client, false);
}

return response.json(productResult);




