/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.wms.mfg.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 商品管理
 *
 * @author Gy
 * @since 4.0.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Product extends BaseClient {

	private static final long serialVersionUID = 1L;

	/**
	 * 商品编码
	 */
	private String code;

	/**
	 * 商品SKU
	 */
	private String sku;

	/**
	 * 商品名称
	 */
	private String name;

	/**
	 * 商品描述
	 */
	private String description;

	/**
	 * 商品名称
	 */
	private String pictureName;

	/**
	 * 商品主图URL
	 */
	private String pictureUrl;

	/**
	 * 商品品牌ID
	 */
	private Long brandId;

	/**
	 * 商品类型ID
	 */
	private Long productTypeId;

	/**
	 * 商品分组ID
	 */
	private Long productGroupId;

	/**
	 * 宽度
	 */
	private BigDecimal width;

	/**
	 * 高度
	 */
	private BigDecimal height;

	/**
	 * 深度
	 */
	private BigDecimal depth;

	/**
	 * 体积
	 */
	private BigDecimal volume;

	/**
	 * 重量
	 */
	private BigDecimal weight;

	/**
	 * 需要收货通知  0：不需要    1：需要
	 */
	private Integer adviceMandatory;

	/**
	 * 需要批次管理  0：不需要    1：需要
	 */
	private Integer lotMandatory;

	/**
	 * 需要有效期管理  0：不需要    1：需要
	 */
	private Integer bestBeforeMandatory;

	/**
	 * 可以用其他批次替代
	 */
	private Integer lotSubstitutionType;

	/**
	 * 收货的最小剩余期限
	 */
	private Integer restUsageGi = 0;

	/**
	 * 拣货的最小剩余期限
	 */
	private Integer restUsageGo;

	/**
	 * 记录序列号类型
	 */
	private Integer serialNoRecordType;

	/**
	 * 记录重量类型
	 */
	private Integer weightRecordType;

	/**
	 * 有效期类型 MANUFACTURE：生产日期，EXPIRATION：到期日期
	 */
	private String bestBeforeType;

	/**
	 * 有效期单位 YEAR：年，MONTH：月，DAY：日
	 */
	private String bestBeforeUnit;

	/**
	 * 保质期之前的最少天数
	 */
	private Integer shelfLife;

	/**
	 * 安全库存
	 */
	private Integer safetyStock;

	/**
	 * 贸易集团
	 */
	private String tradeGroup;

	/**
	 * 默认包装单位ID
	 */
	private Long defaultPackagingUnitId;

	/**
	 * 默认存储策略ID
	 */
	private Long defaultStorageStrategyId;

	/**
	 * 默认装载单元类型ID
	 */
	private Long defaultUnitLoadTypeId;

	/**
	 * 计量单位ID
	 */
	private Long uomId;

	/**
	 * 商品默认存储区域ID
	 */
	private Long zoneId;

}