/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.wms.mfg.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 基础实体类，所有实体都需要继承
 *
 * @author Gy
 * @since 4.0.0
 */
@Data
public abstract class BaseEntitys implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	private Long id;

	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private Long creator;

	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createDate;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 状态  0：停用    1：正常
	 */
	private Integer status;

	/**
	 * 删除标识 0：未删除    1：删除
	 */
	@TableLogic
	private Integer delFlag;

	/**
	 * 版本
	 */
	@Version
	private Integer version;

	/**
	 * 更新者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Long updater;

	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateDate;

	/**
	 * 锁定
	 */
	private Integer entityLock = 0;

	@Transient
	public Integer getLock() {
		return entityLock;
	}

	@Transient
	public void setLock(Integer entityLock) {
		this.entityLock = entityLock;
	}

	public boolean isLocked() {
		return entityLock != 0;
	}

	@Override
	public String toString() {
		return toUniqueString();
	}

	public String toUniqueString() {
		return (getId() == null ? "" : getId().toString());
	}

}
