{
  "properties" : { },
  "id" : "7f4795103fa9469b940676f3c2a05237",
  "script" : null,
  "groupId" : "d0f77f73a23b4374beb298d66a0dd923",
  "name" : "反馈库存数据",
  "createTime" : null,
  "updateTime" : 1677138765230,
  "lock" : null,
  "createBy" : null,
  "updateBy" : "admin",
  "path" : "inventoryFeedbackJobHandler",
  "cron" : "0 * * * * ?",
  "enabled" : true,
  "description" : ""
}
================================
import response;
import env;
import http;
import log;
import 'com.mushiny.wms.mfg.dto.InventoryFeedbackResult' as InventoryFeedbackResult;
import 'com.mushiny.wms.mfg.utils.DateTimeUtil' as DateTimeUtils;
import 'com.mushiny.wms.mfg.constant.ResultStatus' as ResultStatus;
import 'com.mushiny.wms.mfg.entity.LogApi' as LogApi;
import 'cn.hutool.core.bean.BeanUtil' as BeanUtil;
import 'cn.hutool.core.util.IdUtil' as IdUtil;


var url = env.get('custom.url.feedbackInventory');
//mfg本地环境
var DWMSCONNECTIONKEY = env.get('custom.connectionKey');
var MAX_LIMIT_SEND_DATA_SIZE = 200;

var saveLog = (url, param, method, code, result, time, status)=>{
    LogApi logApi = new LogApi();
    logApi.setId(IdUtil.getSnowflakeNextId());
    logApi.setType(1);
    logApi.setCreator(10001L);
    logApi.setCreatorName('ApiUser');
    logApi.setStatus(status);
    logApi.setRequestTime(time::int);
    logApi.setCreateDate(new Date());
    logApi.setUpdater(10001L);
    logApi.setUpdateDate(new Date());
    logApi.setRequestUri(url);
    logApi.setCode('inventory');
    logApi.setName('库存同步反馈');
    logApi.setRequestMethod(method);
    logApi.setRequestParams(param);
    logApi.setResult(result::string);
    logApi.setResultStatus(code);

    db.table('sys_log_api').insert(BeanUtil.beanToMap(logApi))
}

var callInterface = (result, url, connectionId)=>{
    String param = result::stringify;
    log.info("调用的url:{}，发送的数据:{}", url, param);
    long start = System.currentTimeMillis();
    var json = http.connect(url)
    .header({
        'Content-Type' : 'application/json',
        'DWMSCONNECTIONKEY' : DWMSCONNECTIONKEY,
        'DWMSCONNECTIONID' : connectionId,
    })
    .body(result).post().getBody();
    if (is_null(json) || !ResultStatus.success.equals(json.code)) {
        saveLog(url, param, 'POST', 0, json, System.currentTimeMillis() - start, 0);
    }else{
        saveLog(url, param, 'POST', 1, json, System.currentTimeMillis() - start, 1);
    }
    log.info("同步库存完成结果{}", json);
}

var feedback = (list, url, pageNo, totalPage)=>{
    InventoryFeedbackResult result = new InventoryFeedbackResult();
    result.setPage_no(pageNo);
    result.setTotal_page(totalPage);
    list.forEach(InventoryDTO => {
        InventoryFeedbackDetailResult detail = new InventoryFeedbackResult.InventoryFeedbackDetailResult();
        detail.setClient_no(InventoryDTO.clientNo);
        detail.setExternal_sku_id(InventoryDTO.externalSkuId);
        detail.setQuantity(InventoryDTO.quantity::int);
        detail.setExp_date(DateTimeUtils.dateFormat(InventoryDTO.expDate,'yyyy-MM-dd'));
        result.getDetails().add(detail);
    });
    callInterface(result, url, "2116");
}

var sql = """
    select sum(su.quantity) as quantity,
    p.code as externalSkuId,
    sc.code as clientNo,
    case p.best_before_mandatory when 1 then su.strategy_date else null end as expDate
    from inv_stock_unit su
    inner join md_product p on su.product_id = p.id
    inner join sys_client sc on su.client_id = sc.id
    where su.del_flag = 0
    and su.quantity > 0
    group by externalSkuId, clientNo, expDate""";

var inventoryList = db.select(sql); 
if (is_null(inventoryList)) {
    return
}

Integer size = inventoryList.size();

if (MAX_LIMIT_SEND_DATA_SIZE < size) {
    int part = size % MAX_LIMIT_SEND_DATA_SIZE == 0? size/MAX_LIMIT_SEND_DATA_SIZE:size/MAX_LIMIT_SEND_DATA_SIZE+1;
    Integer subSize = MAX_LIMIT_SEND_DATA_SIZE; //截取数据长度：默认值为 最大发送数据长度
    Integer lastSize = size;     				//剩余数据长度：默认值为 库存数据总数量
    log.info("反馈库存数据开始 共: {} 条，分: {} 次反馈", size, part);
    for(val in range(1,part)){ 
        var list = inventoryList.subList(0, subSize);
        feedback(list, url, String.valueOf(val), String.valueOf(part));
        inventoryList.subList(0, subSize).clear();
        lastSize = lastSize - MAX_LIMIT_SEND_DATA_SIZE;
        if (lastSize < MAX_LIMIT_SEND_DATA_SIZE) {
            subSize = lastSize;
        }
    }
} else {
    feedback(inventoryList, url, "1" , "1");
}
