/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.wms.mfg.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 公共字段，自动填充值
 *
 * @author Elen elen.shen@mushiny.comn
 * @since 2.1.0
 */
@Component
public class FieldMetaObjectHandler implements MetaObjectHandler {

    private final static String CREATE_DATE = "createDate";
    private final static String CREATOR = "creator";
    private final static String UPDATE_DATE = "updateDate";
    private final static String UPDATER = "updater";
    private final static String DEL_FLAG = "delFlag";
    private final static String DEPT_ID = "deptId";

    @Value("${mushiny.user}")
    private Long userId;

    @Override
    public void insertFill(MetaObject metaObject) {

        Date date = new Date();

        //更新时间
        strictInsertFill(metaObject, UPDATE_DATE, Date.class, date);

        strictInsertFill(metaObject, CREATE_DATE, Date.class, date);

        //删除标识
        strictInsertFill(metaObject, DEL_FLAG, Integer.class, 0);

        //创建者
        strictInsertFill(metaObject, CREATOR, Long.class, userId);
        //创建时间

        //创建者所属部门
//		strictInsertFill(metaObject, DEPT_ID, Long.class, user.getDeptId());

        //更新者
        strictInsertFill(metaObject, UPDATER, Long.class, userId);

    }

    @Override
    public void updateFill(MetaObject metaObject) {
        //更新时间
        setFieldValByName(UPDATE_DATE, new Date(), metaObject);
        //更新者
        setFieldValByName(UPDATER, userId, metaObject);
    }

}