package com.mushiny.wms.mfg.dto;

import com.mushiny.wms.mfg.constant.DateFormatPattern;
import com.mushiny.wms.mfg.constant.ResultStatus;
import com.mushiny.wms.mfg.constant.TimeZoneConstant;
import com.mushiny.wms.mfg.utils.DateTimeUtil;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author gy
 * @since 4.0.0
 */
@Data
@Accessors(chain = true)
public class BaseResult {

    private String status = ResultStatus.ok;

    private String message = "Success";

    private String datetime = DateTimeUtil.dateFormat(new Date(), DateFormatPattern.dd_MM_yyyy_HH_mm_ss, TimeZoneConstant.AU_TIME_ZONE);

}
