/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.wms.mfg.constant;

/**
 * 日期格式常量
 *
 * @author Gy
 * @since 4.0.0
 */
public class DateFormatPattern {

	/**
	 * 日期格式：yyyy-MM-dd
	 */
	public static final String yyyy_MM_dd = "yyyy-MM-dd";

	/**
	 * 日期格式：dd-MM-yyyy
	 */
	public static final String dd_MM_yyyy = "dd-MM-yyyy";

	/**
	 * 日期格式：dd-MM-yyyy HH:mm
	 */
	public static final String dd_MM_yyyy_HH_mm = "dd-MM-yyyy HH:mm";

	/**
	 * 日期格式：dd-MM-yyyy HH:mm:ss
	 */
	public static final String dd_MM_yyyy_HH_mm_ss = "dd-MM-yyyy HH:mm:ss";

	/**
	 * 日期格式：yyyy-MM-dd HH:mm:ss
	 */
	public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";

	/**
	 * 日期格式：yyyy-MM-dd HH:mm
	 */
	public static final String yyyy_MM_dd_HH_mm = "yyyy-MM-dd HH:mm";

	/**
	 * 日期格式：yyyy-MM-dd hh:mm:ss
	 */
	public static final String yyyy_MM_dd_hh_mm_ss = "yyyy-MM-dd hh:mm:ss";

	/**
	 * 日期格式：yyyy-MM-dd hh:mm
	 */
	public static final String yyyy_MM_dd_hh_mm = "yyyy-MM-dd hh:mm";

	/**
	 * 日期格式：dd-MM-yyyy HH:mm:ss.SSS
	 */
	public static final String dd_MM_yyyy_HH_mm_ss_SSS = "dd-MM-yyyy HH:mm:ss.SSS";

}
