{
  "properties" : { },
  "id" : "51bf348bfc4d4a95855d7df3d8be277a",
  "script" : null,
  "groupId" : "504dbc7823444f7a8df13edb6b189120",
  "name" : "获取商品库存",
  "createTime" : null,
  "updateTime" : 1673849005063,
  "lock" : null,
  "createBy" : null,
  "updateBy" : "admin",
  "path" : "productStock",
  "method" : "POST",
  "parameters" : [ ],
  "options" : [ ],
  "requestBody" : "{\n    \"client_no\": \"Client-FIRST\",\n    \"details\": [{\n        \"external_sku_id\": \"6956445461880\"\n    }, {\n        \"external_sku_id\": \"3130190151310\"\n    }]\n}",
  "headers" : [ ],
  "paths" : [ ],
  "responseBody" : "{\n    \"code\": -1,\n    \"message\": \"系统内部出现错误\",\n    \"data\": null,\n    \"timestamp\": 1673516872009,\n    \"executeTime\": 46\n}",
  "description" : null,
  "requestBodyDefinition" : {
    "name" : "",
    "value" : "",
    "description" : "",
    "required" : false,
    "dataType" : "Object",
    "type" : null,
    "defaultValue" : null,
    "validateType" : "",
    "error" : "",
    "expression" : "",
    "children" : [ {
      "name" : "client_no",
      "value" : "Client-FIRST",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "details",
      "value" : "",
      "description" : "",
      "required" : false,
      "dataType" : "Array",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ {
        "name" : "",
        "value" : "",
        "description" : "",
        "required" : false,
        "dataType" : "Object",
        "type" : null,
        "defaultValue" : null,
        "validateType" : "",
        "error" : "",
        "expression" : "",
        "children" : [ {
          "name" : "external_sku_id",
          "value" : "6956445461880",
          "description" : "",
          "required" : false,
          "dataType" : "String",
          "type" : null,
          "defaultValue" : null,
          "validateType" : "",
          "error" : "",
          "expression" : "",
          "children" : [ ]
        } ]
      } ]
    } ]
  },
  "responseBodyDefinition" : {
    "name" : "",
    "value" : "",
    "description" : "",
    "required" : false,
    "dataType" : "Object",
    "type" : null,
    "defaultValue" : null,
    "validateType" : "",
    "error" : "",
    "expression" : "",
    "children" : [ {
      "name" : "code",
      "value" : "-1",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "message",
      "value" : "系统内部出现错误",
      "description" : "",
      "required" : false,
      "dataType" : "String",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "data",
      "value" : "null",
      "description" : "",
      "required" : false,
      "dataType" : "Object",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "timestamp",
      "value" : "1673516872009",
      "description" : "",
      "required" : false,
      "dataType" : "Long",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    }, {
      "name" : "executeTime",
      "value" : "46",
      "description" : "",
      "required" : false,
      "dataType" : "Integer",
      "type" : null,
      "defaultValue" : null,
      "validateType" : "",
      "error" : "",
      "expression" : "",
      "children" : [ ]
    } ]
  }
}
================================
import response;
import 'com.mushiny.wms.mfg.dto.ProductStockResult' as ProductStock;

var sql = """
    select
    CASE WHEN COALESCE(a.availableQuantity,0) - COALESCE(b.noAllocatedQuantity,0) < 0 THEN 0
    ELSE COALESCE(a.availableQuantity,0) - COALESCE(b.noAllocatedQuantity,0)
    END AS stockQuantity
    from md_product mp
    left join (select
    su.product_id as productId,
    sum(su.quantity-su.reserved_quantity) as availableQuantity
    from inv_stock_unit su
    inner join inv_unit_load ul on ul.id = su.unit_load_id
    inner join md_storage_bin sb on sb.id = ul.storage_bin_id
    inner join md_rack mr on mr.id = sb.rack_id
    where su.del_flag = 0
    and su.quantity > 0
    and su.warehouse_id = #{product.warehouse_id}
    and su.status = 300
    and mr.type ='POD'
    group by productId
    ) a on mp.id = a.productId
    left join (
    select odl.product_id as productId, sum(odl.quantity-odl.allocated_quantity) as noAllocatedQuantity from
    ob_delivery_order_line odl
    inner join ob_delivery_order od on od.id = odl.delivery_order_id
    where od.del_flag = 0
    and od.warehouse_id = #{product.warehouse_id}
    and od.client_id = #{client.id}
    and od.status < 600
    and odl.del_flag = 0
    and odl.status < 600
    group by productId
    ) b on a.productId = b.productId
    where mp.id = #{product.id}"""

ProductStock result = new ProductStock();

var client = db.selectOne("select * from sys_client where code = #{body.client_no} "); 
if(is_null(client)){
    return response.json({status : 'ERROR', message : 'Client does not exist', datetime : date_format(new Date())});
}
if(body.details.size()>100){
    return response.json({status : 'ERROR', message : 'Not more than 100 sku', datetime : date_format(new Date())});
}

val list = new ArrayList();
for(val in body.details){
    var product = db.selectOne("select * from md_product where code = #{val.external_sku_id} and client_id = #{client.id}"); 
    if (is_null(product)) {
        return response.json({status : 'ERROR', message : 'Product does not exist, wrong product is '+ val.external_sku_id, datetime : date_format(new Date())});
    }
    Integer quantity = db.selectInt(sql);
    ProductStock productStock = new ProductStock();
    productStock.setExternal_sku_id(val.external_sku_id);
    productStock.setQuantity(quantity);
    list.add(productStock);
}
return response.json({
    status : 'OK',
    message : 'Success',
    datetime : date_format(new Date()),
    details : list
});


