/*
 * Copyright (c) 2020 牧星仓库管理系统 All rights reserved.
 *
 * http://www.mushiny.com
 *
 * 版权所有，侵权必究！
 */

package com.mushiny.wms.mfg.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 接口日志
 *
 * @author Gy
 * @since 4.0.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class LogApi {

	private static final long serialVersionUID = 1L;

	/**
	 * ID
	 */
	private Long id;

	/**
	 * 接口编码
	 */
	private String code;

	/**
	 * 接口名称
	 */
	private String name;

	/**
	 * 接口唯一key
	 */
	private String unique_key;

	/**
	 * 接口类型 0：接收(对方调用我方提供接口received) 1：发送(我方调用对方提供接口send)
	 */
	private Integer type;


	/**
	 * 请求URI
	 */
	private String request_uri;

	/**
	 * 请求方式
	 */
	private String request_method;

	/**
	 * 请求参数
	 */
	private String request_params;

	/**
	 * 请求时长(毫秒)
	 */
	private Integer request_time;

	/**
	 * 用户代理
	 */
	private String user_agent;

	/**
	 * 操作IP
	 */
	private String ip;

	/**
	 * 状态  0：失败   1：成功
	 */
	private Integer status;

	/**
	 * 返回结果
	 */
	private String result;

	/**
	 * 结果状态 0：失败   1：成功
	 */
	private Integer result_status;

	/**
	 * 重试次数
	 */
	private Integer retry_num;


	/**
	 * 用户名
	 */
	private String creator_name;

	/**
	 * 创建者
	 */
	private Long creator;

	/**
	 * 创建时间
	 */
	private Date create_date;

	/**
	 * 更新者
	 */
	private Long updater;

	/**
	 * 更新时间
	 */
	private Date update_date;
}