package com.mushiny.wms.mfg.dto;

import com.mushiny.wms.mfg.constant.DateFormatPattern;
import com.mushiny.wms.mfg.constant.TimeZoneConstant;
import com.mushiny.wms.mfg.utils.DateTimeUtil;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Gy
 * @since 4.0.0
 */
@ApiModel(value = "同步库存")
@Data
public class InventoryFeedbackResult implements Serializable {

	private static final long serialVersionUID = 1L;

	private String page_no;

	private String total_page;

	private String operation_datetime = DateTimeUtil.dateFormat(new Date(), DateFormatPattern.dd_MM_yyyy_HH_mm_ss_SSS, TimeZoneConstant.AU_TIME_ZONE);

	private List<InventoryFeedbackDetailResult> details = new ArrayList<>();

	@Data
	public static class InventoryFeedbackDetailResult implements Serializable {

		private String client_no;

		private String external_sku_id;

		private Integer quantity;

		private String exp_date;
	}
}
